package net.customware.license.confluence.prefs;

import net.customware.license.support.util.AbstractLicensePreferences;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;

public abstract class AbstractBandanaPreferences extends AbstractLicensePreferences {

    private static final String PREFIX = "java.util.prefs:";

    private BandanaManager bandanaManager;

    private BandanaContext ctx;

    public AbstractBandanaPreferences( BandanaContext ctx ) {
        this( ctx, null, "" );
    }

    public AbstractBandanaPreferences( BandanaContext ctx, AbstractBandanaPreferences parent, String path ) {
        super( parent, path );
        this.ctx = ctx;
    }

    @Override protected String getSpi( String key ) {
        return ( String ) getBandanaManager().getValue( ctx, getFullPath( key ) );
    }

    private String getFullPath( String key ) {
        return PREFIX + absolutePath() + "//" + key;
    }

    @Override protected void putSpi( String key, String value ) {
        getBandanaManager().setValue( ctx, getFullPath( key ), value );
    }

    @Override protected void removeSpi( String key ) {
        getBandanaManager().setValue( ctx, getFullPath( key ), null );
    }

    protected BandanaManager getBandanaManager() {
        if ( bandanaManager == null )
            bandanaManager = ( BandanaManager ) ContainerManager.getComponent( "bandanaManager" );
        return bandanaManager;
    }
}