package net.customware.license.confluence.exemption;

import net.customware.license.atlassian.exemption.LicenseTypeExemption;

import com.atlassian.license.License;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;

/**
 * An exemption for standard Confluence 'Evaluation' or 'Demo' licenses.
 */
public class EvaluationLicenseTypeExemption extends LicenseTypeExemption {

    public EvaluationLicenseTypeExemption() {
        super( ConfluenceLicenseTypeStore.DEMONSTRATION, ConfluenceLicenseTypeStore.EVALUATION,
                ConfluenceLicenseTypeStore.HOSTED_EVALUATION, ConfluenceLicenseTypeStore.TESTING );
    }

    @Override public boolean isExempt( Object context ) {
        if ( !super.isExempt( context ) ) {
            License license = getLicense( context );
            if ( license != null && license.getLicenseType().isEvaluationLicenseType() )
                return true;
            return false;
        }
        return true;
    }

}
