/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence.restriction;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.spring.container.ContainerManager;
import net.customware.license.atlassian.restriction.AbstractLicenseRestriction;
import net.customware.license.support.simple.SimpleLicenseContent;
import net.customware.license.support.simple.SimpleRestrictionException;

public class ServerIdRestriction
extends AbstractLicenseRestriction {
    private ConfluenceSidManager sidManager;

    protected void checkRestriction(Object context, SimpleLicenseContent content, Object attributeValue) throws SimpleRestrictionException {
        if (attributeValue != null && !"".equals(attributeValue)) {
            try {
                String sid = this.getSidManager().getSid();
                String attrSid = attributeValue.toString().trim();
                if (!sid.equals(attrSid)) {
                    throw new SimpleRestrictionException("The the Confluence Server ID (" + sid + ") does not match that specified by the license key (" + attrSid + ").");
                }
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                throw new SimpleRestrictionException(e.getMessage());
            }
        }
    }

    public static void setServerId(SimpleLicenseContent content, String serverId) {
        content.setAttribute(ServerIdRestriction.class, (Object)serverId);
    }

    public static String getServerId(SimpleLicenseContent content) {
        return (String)content.getAttribute(ServerIdRestriction.class);
    }

    private ConfluenceSidManager getSidManager() {
        if (this.sidManager == null) {
            this.sidManager = (ConfluenceSidManager)ContainerManager.getComponent((String)"sidManager");
        }
        return this.sidManager;
    }
}

