/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.renderer.v2.macro.MacroException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.NoLicenseInstalledException;
import org.apache.log4j.Logger;
import org.randombits.confluence.support.ConfluenceMacro;
import org.randombits.confluence.support.I18NAssistant;
import org.randombits.confluence.support.MacroInfo;

public abstract class LicensedConfluenceMacro
extends ConfluenceMacro {
    private static final Logger LOG = Logger.getLogger(LicensedConfluenceMacro.class);
    private static LicenseManager licenseManager;

    protected final String execute(MacroInfo info) throws MacroException {
        try {
            this.getLicenseManager().verify();
        }
        catch (NoLicenseInstalledException e) {
            LOG.info((Object)e.getLocalizedMessage());
            return this.executeUnverified(info, (Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return this.executeUnverified(info, e);
        }
        return this.executeVerified(info);
    }

    protected String executeUnverified(MacroInfo info, Exception e) throws MacroException {
        return "<p><span class='error'>" + I18NAssistant.getInstance().getText("license.error.licenseUnverified", (Object[])new String[]{e.getLocalizedMessage()}) + "</span></p>";
    }

    protected abstract String executeVerified(MacroInfo var1) throws MacroException;

    protected LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = this.createLicenseManager();
        }
        return licenseManager;
    }

    protected abstract LicenseManager createLicenseManager();
}

