/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.license.LicenseType;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.customware.license.atlassian.AtlassianLicenseParam;
import net.customware.license.atlassian.DefaultLicenseContext;
import net.customware.license.atlassian.LicenseContext;
import net.customware.license.confluence.prefs.ConfluenceSystemPreferences;
import net.customware.license.confluence.prefs.ConfluenceUserPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfluenceLicenseParam
extends AtlassianLicenseParam {
    private static final List<LicenseType> LICENSE_TYPES = new ArrayList<LicenseType>();
    private static LicenseContext LICENSE_CONTEXT;

    public static LicenseType findLicenseType(int id) {
        for (LicenseType type : LICENSE_TYPES) {
            if (type.getType() != id) continue;
            return type;
        }
        return null;
    }

    public static Collection<LicenseType> findLicenseTypes() {
        return LICENSE_TYPES;
    }

    public static LicenseContext getLicenseContext() {
        return LICENSE_CONTEXT;
    }

    public LicenseType getLicenseType(int id) {
        return ConfluenceLicenseParam.findLicenseType(id);
    }

    protected void preInit() {
        this.requireLicensePerServer();
    }

    protected void requireLicensePerServer() {
        this.setPreferences(new ConfluenceSystemPreferences().nodeForPackage(((Object)((Object)this)).getClass()));
    }

    protected void requireLicensePerUser() {
        this.setPreferences(new ConfluenceUserPreferences().nodeForPackage(((Object)((Object)this)).getClass()));
    }

    public Object getContext() {
        return ConfluenceLicenseParam.getLicenseContext();
    }

    static {
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.ACADEMIC);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.COMMUNITY);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.DEMONSTRATION);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.DEVELOPER);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.EVALUATION);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.FULL_LICENSE);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.HOSTED);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.HOSTED_EVALUATION);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.NON_PROFIT);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.OPEN_SOURCE);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.PERSONAL);
        LICENSE_TYPES.add(ConfluenceLicenseTypeStore.TESTING);
        LICENSE_CONTEXT = new DefaultLicenseContext("CONF");
    }
}

