/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import java.io.File;
import java.io.FileOutputStream;
import javax.security.auth.x500.X500Principal;
import net.customware.license.support.util.LicenseUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLicenseAction
extends ConfluenceActionSupport {
    private static final long MILLIS_PER_DAY = 86400000L;
    private static LicenseManager licenseManager = null;
    private MultiPartRequestWrapper multiPartRequest;
    private String install;
    private String uninstall;
    private String licenseText;

    protected MultiPartRequestWrapper getMultiPartRequest() {
        if (this.multiPartRequest == null && ServletActionContext.getRequest() instanceof MultiPartRequestWrapper) {
            this.multiPartRequest = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        }
        return this.multiPartRequest;
    }

    public String execute() {
        if (this.uninstall != null) {
            return this.doUninstall();
        }
        if (this.install != null) {
            return this.doInstall();
        }
        return "input";
    }

    private String doUninstall() {
        try {
            this.getLicenseManager().uninstall();
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addActionError(this.getText(e.getLocalizedMessage()));
            return "error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doInstall() {
        try {
            File file = null;
            File[] licenseFiles = this.getMultiPartRequest().getFiles("licenseFile");
            if (licenseFiles == null || licenseFiles.length >= 1 && licenseFiles[0] == null) {
                if (!StringUtils.isNotBlank((String)this.licenseText)) {
                    this.addActionError(this.getText("license.error.licenseRequired"));
                    return "error";
                }
                file = File.createTempFile("plugin_", ".key");
                FileOutputStream out = new FileOutputStream(file);
                out.write(Base64.decodeBase64((byte[])this.licenseText.getBytes("ascii")));
                out.close();
            } else {
                file = licenseFiles[0];
            }
            this.getLicenseManager().install(file);
            file.delete();
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addActionError(this.getText(e.getLocalizedMessage()));
            return "error";
        }
    }

    public LicenseContent getLicenseContent() {
        try {
            return this.getLicenseManager().verify();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLicenseHolder() {
        LicenseContent content = this.getLicenseContent();
        if (content != null) {
            return LicenseUtils.formatX500Principal((X500Principal)content.getHolder());
        }
        return null;
    }

    public String getLicenseIssuer() {
        LicenseContent content = this.getLicenseContent();
        if (content != null) {
            return LicenseUtils.formatX500Principal((X500Principal)content.getIssuer());
        }
        return null;
    }

    public int getLicenseExpiring() {
        LicenseContent lc = this.getLicenseContent();
        if (lc != null && lc.getNotAfter() != null) {
            long now = System.currentTimeMillis();
            long expires = lc.getNotAfter().getTime();
            return (int)((expires - now) / 86400000L);
        }
        return Integer.MAX_VALUE;
    }

    public String getInstall() {
        return this.install;
    }

    public void setInstall(String upload) {
        this.install = upload;
    }

    protected LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = this.createLicenseManager();
        }
        return licenseManager;
    }

    public String getUninstall() {
        return this.uninstall;
    }

    public void setUninstall(String uninstall) {
        this.uninstall = uninstall;
    }

    public String getAbsoluteEulaPath() {
        String eulaPath = this.getEulaPath();
        if (eulaPath != null && eulaPath.startsWith("/")) {
            eulaPath = this.getGlobalSettings().getBaseUrl() + eulaPath;
        }
        return eulaPath;
    }

    protected abstract LicenseManager createLicenseManager();

    public abstract String getPluginName();

    public abstract String getEulaPath();

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }
}

