package net.customware.license.confluence.prefs;

import java.util.prefs.AbstractPreferences;

import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;

/**
 * This is an incomplete implementation of the Preferences API, with only enough
 * implemented to support the TrueLicense API.
 * 
 * When this class is used as the Preferences implementation for TrueLicense,
 * the license key will be stored in Bandana, available across the whole server.
 * 
 * @author David Peterson
 */
public class ConfluenceSystemPreferences extends AbstractBandanaPreferences {
    public ConfluenceSystemPreferences() {
        super( new ConfluenceBandanaContext() );
    }

    protected ConfluenceSystemPreferences( ConfluenceSystemPreferences parent, String name ) {
        super( new ConfluenceBandanaContext(), parent, name );
    }

    @Override protected AbstractPreferences childSpi( String name ) {
        return new ConfluenceSystemPreferences( this, name );
    }
}
