/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.transport;

import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.path.Url;
import net.csdn.common.settings.Settings;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.support.HttpStatus;
import net.csdn.modules.threadpool.ThreadPoolService;
import net.csdn.modules.transport.HttpTransportService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class DefaultHttpTransportService
implements HttpTransportService {
    private final HttpClient httpClient;
    private CSLogger logger = Loggers.getLogger(this.getClass());
    public static final String charset = "utf-8";
    private static final Tuple<String, String> content_type = new Tuple((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
    private ThreadPoolService threadPoolService;
    private Settings settings;
    private static final Map<String, String> EMPTY_MAP = WowCollections.map((Object[])new Object[0]);

    @Inject
    public DefaultHttpTransportService(ThreadPoolService threadPoolService, Settings settings) {
        this.threadPoolService = threadPoolService;
        this.settings = settings;
        PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager();
        poolingClientConnectionManager.setMaxTotal(settings.getAsInt("http.client.max_total", Integer.valueOf(100)).intValue());
        poolingClientConnectionManager.setDefaultMaxPerRoute(settings.getAsInt("http.client.default_max_per_route", Integer.valueOf(50)).intValue());
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)settings.getAsInt("http.client.connect.timeout", Integer.valueOf(5000)));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)settings.getAsInt("http.client.accept.timeout", Integer.valueOf(5000)));
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)poolingClientConnectionManager, (HttpParams)httpParams);
    }

    @Override
    public void header(String header, String value) {
        this.httpClient.getParams().setParameter(header, (Object)value);
    }

    @Override
    public HttpTransportService.SResponse post(Url url, Map data) {
        return this.post(url, data, EMPTY_MAP);
    }

    @Override
    public HttpTransportService.SResponse post(final Url url, final Map data, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.post(url, data);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse post(Url url, Map data, Map<String, String> headers) {
        HttpPost post = null;
        try {
            post = new HttpPost(url.toURI());
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.mapToNameValuesPairs(data), charset);
            post.setHeader((String)content_type.v1(), (String)content_type.v2());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            post.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            if (post != null) {
                post.abort();
            }
            this.logger.error("Error when remote search url:[{}] ", new Object[]{url.toString()});
            return null;
        }
    }

    @Override
    public HttpTransportService.SResponse post(final Url url, final Map data, final Map<String, String> headers, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.post(url, data, headers);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse put(Url url, Map data) {
        return this.put(url, data, EMPTY_MAP);
    }

    public HttpTransportService.SResponse put(final Url url, final Map data, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.put(url, data);
            }
        });
        return response;
    }

    public HttpTransportService.SResponse put(final Url url, final Map data, final Map<String, String> headers, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.put(url, data, headers);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse put(Url url, Map data, Map<String, String> headers) {
        HttpPut put = null;
        try {
            put = new HttpPut(url.toURI());
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.mapToNameValuesPairs(data), charset);
            put.setHeader((String)content_type.v1(), (String)content_type.v2());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    put.setHeader(entry.getKey(), entry.getValue());
                }
            }
            put.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getName() + " error when visit url:[{}] ", new Object[]{url.toString()});
            if (put != null) {
                put.abort();
            }
            return null;
        }
    }

    @Override
    public HttpTransportService.SResponse get(Url url) {
        return this.http(url, null, RestRequest.Method.GET);
    }

    @Override
    public HttpTransportService.SResponse get(Url url, Map<String, String> data) {
        for (Map.Entry<String, String> item : data.entrySet()) {
            try {
                url.addParam(item.getKey(), URLEncoder.encode(item.getValue(), charset));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.get(url);
    }

    @Override
    public HttpTransportService.SResponse get(final Url url, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.get(url);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse get(final Url url, final Map<String, String> data, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.get(url, data);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse http(Url url, String jsonData, RestRequest.Method method) {
        return this.http(url, jsonData, EMPTY_MAP, method);
    }

    @Override
    public HttpTransportService.SResponse http(Url url, String jsonData, Map<String, String> headers, RestRequest.Method method) {
        HttpRequestBase httpRequestBase = null;
        try {
            httpRequestBase = this.createMethod(url, jsonData, method);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpRequestBase.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            if (httpRequestBase != null) {
                httpRequestBase.abort();
            }
            return new HttpTransportService.SResponse(HttpStatus.HttpStatusServerDown, "", url);
        }
    }

    @Override
    public HttpTransportService.SResponse http(final Url url, final String jsonData, final RestRequest.Method method, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.http(url, jsonData, method);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse http(final Url url, final String jsonData, final Map<String, String> headers, final RestRequest.Method method, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.http(url, jsonData, headers, method);
            }
        });
        return response;
    }

    @Override
    public FutureTask<HttpTransportService.SResponse> asyncHttp(final Url url, final String jsonData, final RestRequest.Method method) {
        FutureTask<HttpTransportService.SResponse> getRemoteDataTask = new FutureTask<HttpTransportService.SResponse>(new Callable<HttpTransportService.SResponse>(){

            @Override
            public HttpTransportService.SResponse call() throws Exception {
                return DefaultHttpTransportService.this.http(url, jsonData, method);
            }
        });
        this.threadPoolService.executor("search").execute(getRemoteDataTask);
        return getRemoteDataTask;
    }

    @Override
    public List<Tuple<Url, HttpTransportService.SResponse>> asyncHttps(Map<Url, String> urlWithPostString, RestRequest.Method method, int timeout) {
        ArrayList<Tuple<Url, HttpTransportService.SResponse>> responses = new ArrayList<Tuple<Url, HttpTransportService.SResponse>>();
        ArrayList<Tuple> futureTasks = new ArrayList<Tuple>(urlWithPostString.size());
        for (Map.Entry<Url, String> entry : urlWithPostString.entrySet()) {
            Url url = entry.getKey();
            FutureTask<HttpTransportService.SResponse> getRemoteDataTask = this.asyncHttp(url, entry.getValue(), method);
            futureTasks.add(new Tuple((Object)url, getRemoteDataTask));
        }
        for (Tuple futureTask : futureTasks) {
            try {
                HttpTransportService.SResponse sResponse = (HttpTransportService.SResponse)((FutureTask)futureTask.v2()).get(timeout, TimeUnit.MILLISECONDS);
                responses.add((Tuple<Url, HttpTransportService.SResponse>)new Tuple(futureTask.v1(), (Object)sResponse));
            }
            catch (Exception e) {
                this.logger.error("fetch " + futureTask.v1() + " error:", (Throwable)e, new Object[0]);
                responses.add((Tuple<Url, HttpTransportService.SResponse>)new Tuple(futureTask.v1(), (Object)new HttpTransportService.SResponse(503, e.getMessage(), (Url)futureTask.v1())));
            }
        }
        return responses;
    }

    @Override
    public List<HttpTransportService.SResponse> asyncHttps(List<Url> urls, String jsonData, RestRequest.Method method) {
        ArrayList<HttpTransportService.SResponse> responses = new ArrayList<HttpTransportService.SResponse>(urls.size());
        ArrayList<FutureTask<HttpTransportService.SResponse>> futureTasks = new ArrayList<FutureTask<HttpTransportService.SResponse>>(urls.size());
        for (int i = 0; i < urls.size(); ++i) {
            Url url = urls.get(i);
            FutureTask<HttpTransportService.SResponse> getRemoteDataTask = this.asyncHttp(url, jsonData, method);
            futureTasks.add(getRemoteDataTask);
        }
        for (FutureTask futureTask : futureTasks) {
            try {
                HttpTransportService.SResponse sResponse = (HttpTransportService.SResponse)futureTask.get(5L, TimeUnit.SECONDS);
                responses.add(sResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                futureTask.cancel(true);
            }
        }
        return responses;
    }

    private HttpRequestBase createMethod(Url url, String jsonData, RestRequest.Method method) {
        HttpGet httpRequestBase;
        URI uri = url.toURI();
        if (method == RestRequest.Method.GET) {
            httpRequestBase = new HttpGet(uri);
        } else if (method == RestRequest.Method.PUT) {
            httpRequestBase = new HttpPut(uri);
            if (jsonData != null && !jsonData.isEmpty()) {
                ((HttpPut)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            }
        } else if (method == RestRequest.Method.DELETE) {
            if (jsonData != null && !jsonData.isEmpty()) {
                httpRequestBase = new HttpPost(uri);
                url.addParam("_method", "DELETE");
                ((HttpPost)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            } else {
                httpRequestBase = new HttpDelete(uri);
            }
        } else if (method == RestRequest.Method.HEAD) {
            httpRequestBase = new HttpHead(uri);
        } else if (method == RestRequest.Method.OPTIONS) {
            httpRequestBase = new HttpOptions(uri);
        } else {
            httpRequestBase = new HttpPost(uri);
            if (jsonData != null && !jsonData.isEmpty()) {
                ((HttpPost)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            }
        }
        return httpRequestBase;
    }

    private StringEntity stringEntity(String jsonData) {
        try {
            return new StringEntity(jsonData, charset);
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getName() + "UnsupportedEncodingException e=>" + e.getMessage(), new Object[0]);
            return null;
        }
    }

    private List<NameValuePair> mapToNameValuesPairs(Map data) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Object key : data.keySet()) {
            params.add((NameValuePair)new BasicNameValuePair((String)key, (String)data.get(key)));
        }
        return params;
    }

    public void shutdownTransport() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

