/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.thrift.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.mongo.Document;
import net.sf.json.JSONObject;

public class PojoCopy {
    private static CSLogger logger = Loggers.getLogger(PojoCopy.class);

    public static <T> List<T> buildAll(List from, Class<T> to) {
        try {
            List temp = (List)from.getClass().newInstance();
            for (Object obj : from) {
                temp.add(PojoCopy.build(obj, to));
            }
            return temp;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T build(Object from, Class<T> to) {
        try {
            T t = to.newInstance();
            PojoCopy.copyProperties(from, t);
            return t;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void copyProperties(Object from, Object to) {
        if (to instanceof Document) {
            PojoCopy.thriftPojoToDocument(from, (Document)to);
            return;
        }
        if (from instanceof Document) {
            PojoCopy.documentToThriftPojo((Document)from, to);
            return;
        }
        for (Field field : to.getClass().getFields()) {
            String name = field.getName();
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value = from instanceof Map ? ((Map)from).get(name) : ReflectHelper.field((Object)from, (String)name);
                if (value == null) continue;
                if (PojoCopy.isBasicType(value)) {
                    ReflectHelper.field((Object)to, (String)name, (Object)value);
                    continue;
                }
                if (value instanceof List) {
                    PojoCopy.ListProcess(from, to, name, value);
                    continue;
                }
                if (value instanceof Map) {
                    PojoCopy.MapProcess(from, to, name, value);
                    continue;
                }
                if (value instanceof Set) {
                    PojoCopy.SetProcess(from, to, name, value);
                    continue;
                }
                Object newDoc = ReflectHelper.field((Object)to, (String)name).getClass().newInstance();
                PojoCopy.copyProperties(value, newDoc);
                ReflectHelper.field((Object)to, (String)name, newDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info(e.getMessage(), new Object[0]);
            }
        }
    }

    public static void thriftPojoToDocument(Object obj, Document doc) {
        doc.attributes().putAll(JSONObject.fromObject((Object)obj));
        doc.copyAllAttributesToPojoFields();
    }

    private static void ListProcess(Object from, Object to, String key, Object value) throws Exception {
        List tempValue = (List)value;
        List newTempValue = (List)value.getClass().newInstance();
        for (Object temp : tempValue) {
            if (PojoCopy.isBasicType(temp)) {
                newTempValue.add(temp);
                continue;
            }
            Class newDocClass = (Class)((ParameterizedType)to.getClass().getField(key).getGenericType()).getActualTypeArguments()[0];
            Object newDoc = newDocClass.newInstance();
            PojoCopy.copyProperties(temp, newDoc);
            newTempValue.add(newDoc);
        }
        ReflectHelper.field((Object)to, (String)key, (Object)newTempValue);
    }

    private static void SetProcess(Object from, Object to, String key, Object value) throws Exception {
        Set tempValue = (Set)value;
        Set newTempValue = (Set)value.getClass().newInstance();
        for (Object temp : tempValue) {
            if (PojoCopy.isBasicType(temp)) {
                newTempValue.add(temp);
                continue;
            }
            Class newDocClass = (Class)((ParameterizedType)to.getClass().getField(key).getGenericType()).getActualTypeArguments()[0];
            Object newDoc = newDocClass.newInstance();
            PojoCopy.copyProperties(temp, newDoc);
            newTempValue.add(newDoc);
        }
        ReflectHelper.field((Object)to, (String)key, (Object)newTempValue);
    }

    private static void MapProcess(Object from, Object to, String key, Object value) throws Exception {
        Class<?> newDocClass = to.getClass().getField(key).getType();
        Object newDoc = newDocClass.newInstance();
        PojoCopy.copyProperties(value, newDoc);
        ReflectHelper.field((Object)to, (String)key, newDoc);
    }

    public static void documentToThriftPojo(Document doc, Object to) {
        Map keyValues = doc.attributes();
        PojoCopy.copyProperties(keyValues, to);
    }

    private static boolean isBasicType(Object value) {
        return value instanceof String || value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof Float;
    }
}

