/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.dubbo;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import net.csdn.common.env.Environment;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

@Singleton
public class DubboServer {
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private Settings settings;
    private ApplicationContext ctx;

    public <T> T getBean(String name, Class<T> clzzz) {
        return (T)this.ctx.getBean(name);
    }

    @Inject
    public DubboServer(Settings settings, Environment env) {
        this.settings = settings;
        try {
            ArrayList<String> configFiles = new ArrayList<String>();
            for (File file : env.configFile().listFiles()) {
                if (file.getName().endsWith("_test_client.xml")) {
                    configFiles.add("file:" + file.getPath());
                }
                if (!file.getName().endsWith("_server.xml") && (!file.getName().endsWith("_client.xml") || file.getName().endsWith("_test_client.xml"))) continue;
                configFiles.add("file:" + file.getPath());
            }
            if (configFiles.size() == 0) {
                return;
            }
            String[] configFilesS = new String[configFiles.size()];
            configFiles.toArray(configFilesS);
            this.ctx = new FileSystemXmlApplicationContext(configFilesS);
            this.logger.info("dubbo provider is running...", new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error("start dubbo fail", (Throwable)ex, new Object[0]);
        }
    }
}

