/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.hibernate.support;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import net.csdn.hibernate.support.filter.CSDNStatFilterstat;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class DruidConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = 1026193803901107651L;
    private DruidDataSource dataSource = new DruidDataSource();

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.dataSource.isWrapperFor(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.dataSource.unwrap(unwrapType);
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public void configure(Map configurationValues) {
        try {
            DruidDataSourceFactory.config((DruidDataSource)this.dataSource, (Map)configurationValues);
            CSDNStatFilterstat statFilterstat = new CSDNStatFilterstat();
            statFilterstat.configFromProperties(this.dataSource.getConnectProperties());
            this.dataSource.getProxyFilters().add(statFilterstat);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("config error", e);
        }
    }

    public void stop() {
        this.dataSource.close();
    }
}

