/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.exception.ArgumentErrorException;
import net.csdn.common.exception.RecordExistedException;
import net.csdn.common.exception.RecordNotFoundException;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestResponse;
import net.csdn.modules.http.ViewType;
import net.csdn.modules.http.support.HttpStatus;
import net.sf.json.JSONException;

public class DefaultResponse
implements RestResponse {
    private String content;
    private byte[] contentByte;
    private int status = HttpStatus.HttpStatusOK;
    private String content_type = "application/json; charset=UTF-8";
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private RestController restController;
    private String redirectPath;

    public DefaultResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RestController restController) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.restController = restController;
    }

    @Override
    public void write(String content) {
        this.content = content;
    }

    private void configureMimeType(ViewType viewType) {
        if (viewType == ViewType.xml) {
            this.content_type = "application/xml;charset=UTF-8";
        } else if (viewType == ViewType.image) {
            this.content_type = "image/jpeg";
        } else if (viewType == ViewType.string) {
            this.content_type = "text/plain;charset=UTF-8";
        } else if (viewType == ViewType.html) {
            this.content_type = "text/html;charset=UTF-8";
        } else if (viewType == ViewType.stream) {
            this.content_type = "application/octet-stream";
        }
    }

    @Override
    public void write(String content, ViewType viewType) {
        this.configureMimeType(viewType);
        this.content = content;
    }

    @Override
    public void write(int httpStatus, String content) {
        this.content = content;
        this.status = httpStatus;
    }

    @Override
    public void write(int httpStatus, String content, ViewType viewType) {
        this.configureMimeType(viewType);
        this.content = content;
        this.status = httpStatus;
    }

    @Override
    public void write(byte[] contentByte) {
        this.contentByte = contentByte;
    }

    @Override
    public void cookie(String name, String value) {
        this.httpServletResponse.addCookie(new Cookie(name, value));
    }

    @Override
    public void cookie(Map cookieInfo) {
        Cookie cookie = new Cookie((String)cookieInfo.get("name"), (String)cookieInfo.get("value"));
        if (cookieInfo.containsKey("domain")) {
            cookie.setDomain((String)cookieInfo.get("domain"));
        }
        if (cookieInfo.containsKey("max_age")) {
            cookie.setMaxAge(((Integer)cookieInfo.get("max_age")).intValue());
        }
        if (cookieInfo.containsKey("path")) {
            cookie.setPath((String)cookieInfo.get("path"));
        }
        if (cookieInfo.containsKey("secure")) {
            cookie.setSecure(((Boolean)cookieInfo.get("secure")).booleanValue());
        }
        if (cookieInfo.containsKey("version")) {
            cookie.setVersion(((Integer)cookieInfo.get("version")).intValue());
        }
        this.httpServletResponse.addCookie(cookie);
    }

    @Override
    public String content() {
        return this.content;
    }

    @Override
    public Object originContent() {
        return null;
    }

    @Override
    public void redirectTo(String path, Map params) {
        HashMap temp = Maps.newHashMap();
        try {
            for (Object o : params.keySet()) {
                if (params.get(o) instanceof String) {
                    temp.put(o, URLEncoder.encode((String)params.get(o), "UTF-8"));
                    continue;
                }
                temp.put(o, params.get(o));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String param = Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)temp);
        if (path.contains("?")) {
            path = path + "&" + param;
        } else if (params.size() != 0) {
            path = path + "?" + param;
        }
        this.redirectPath = path;
    }

    @Override
    public RestResponse originContent(Object obj) {
        return null;
    }

    @Override
    public int status() {
        return this.status;
    }

    public void send() throws IOException {
        this.httpServletResponse.setContentType(this.content_type);
        if ("application/octet-stream".equals(this.content_type)) {
            return;
        }
        if (!WowCollections.isNull((Object)this.redirectPath)) {
            this.httpServletResponse.sendRedirect(this.httpServletResponse.encodeRedirectURL(this.redirectPath));
            return;
        }
        if (this.content == null) {
            this.output("null");
            return;
        }
        if (this.content != null) {
            this.output(this.content);
            return;
        }
        if (this.contentByte != null) {
            this.outputAsByte(this.contentByte);
            return;
        }
    }

    public void error(Exception e) throws IOException {
        this.status = e instanceof RecordNotFoundException ? HttpStatus.HttpStatusNotFound : (e instanceof RecordExistedException || e instanceof ArgumentErrorException || e instanceof JSONException ? HttpStatus.HttpStatusBadRequest : HttpStatus.HttpStatusSystemError);
        this.httpServletResponse.setContentType("text/plain;charset=UTF-8");
        this.httpServletResponse.setStatus(this.status);
        this.output(e.getMessage());
    }

    public void output(String msg) throws IOException {
        this.httpServletResponse.setStatus(this.status);
        PrintWriter printWriter = this.httpServletResponse.getWriter();
        printWriter.write(msg);
        printWriter.flush();
        printWriter.close();
    }

    @Override
    public PrintWriter printWriter() throws IOException {
        return this.httpServletResponse.getWriter();
    }

    @Override
    public ServletOutputStream outputStream() throws IOException {
        return this.httpServletResponse.getOutputStream();
    }

    @Override
    public HttpServletResponse httpServletResponse() throws IOException {
        return this.httpServletResponse;
    }

    @Override
    public String contentType() {
        return this.content_type;
    }

    public void outputAsByte(byte[] msg) throws IOException {
        this.httpServletResponse.setStatus(this.status);
        ServletOutputStream outputStream = this.httpServletResponse.getOutputStream();
        outputStream.write(msg);
        outputStream.flush();
        outputStream.close();
    }
}

