/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.rest;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.csdn.annotation.Param;
import net.csdn.annotation.rest.At;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.path.Url;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.transport.HttpTransportService;
import net.csdn.trace.RemoteTraceElementKey;
import net.csdn.trace.Trace;
import net.csdn.trace.TraceContext;
import net.csdn.trace.VisitType;
import org.apache.commons.lang3.exception.ExceptionUtils;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class RestClientProxy
implements InvocationHandler {
    private CSLogger logger = Loggers.getLogger(RestClientProxy.class);
    private String url;
    private HttpTransportService httpTransportService;

    public RestClientProxy(HttpTransportService httpTransportService) {
        this.httpTransportService = httpTransportService;
    }

    public void target(String url) {
        this.url = url;
    }

    public String hostAndPort() {
        return new Url(this.url).hostAndPort();
    }

    public String url() {
        return this.url;
    }

    private String encodeParams(java.util.Map<String, String> params) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (Map.Entry<String, String> en : params.entrySet()) {
            try {
                keywords.add(en.getKey() + "=" + URLEncoder.encode(en.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return WowCollections.join(keywords, (String)"&");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        void var16_38;
        Url finalUrl;
        block28: {
            long responseLength;
            int responseStatus;
            String message;
            TraceContext traceContext;
            block27: {
                void var16_37;
                int i;
                At at = method.getAnnotation(At.class);
                if (at == null) {
                    return method.invoke(o, objects);
                }
                String path = at.path()[0];
                RestRequest.Method[] httpMethods = at.types();
                HashMap<String, String> params = new HashMap<String, String>();
                RestRequest.Method reqMethod = httpMethods[0];
                String body = null;
                Annotation[][] annotations = method.getParameterAnnotations();
                for (i = 0; i < objects.length; ++i) {
                    Object object = objects[i];
                    if (annotations[i].length > 0) continue;
                    if (object instanceof java.util.Map) {
                        params.putAll((java.util.Map)object);
                        continue;
                    }
                    if (object instanceof scala.collection.immutable.Map) {
                        scala.collection.immutable.Map kk = (scala.collection.immutable.Map)object;
                        java.util.Map newKK = JavaConversions.mapAsJavaMap((Map)kk);
                        params.putAll(newKK);
                        continue;
                    }
                    if (object instanceof RestRequest.Method) {
                        reqMethod = (RestRequest.Method)((Object)object);
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    body = (String)object;
                }
                for (i = 0; i < annotations.length; ++i) {
                    scala.collection.immutable.Map map;
                    for (scala.collection.immutable.Map map2 : map = annotations[i]) {
                        if (!(map2 instanceof Param)) continue;
                        Param temp = (Param)map2;
                        params.put(temp.value(), (String)objects[i]);
                    }
                }
                boolean methodSupport = false;
                for (RestRequest.Method method2 : httpMethods) {
                    if (!method2.equals((Object)reqMethod)) continue;
                    methodSupport = true;
                }
                if (!methodSupport) {
                    throw new RuntimeException((Object)((Object)reqMethod) + "not support in invoke " + this.url);
                }
                ArrayList arrayList = new ArrayList();
                String remenberPath = path;
                for (Map.Entry entry : params.entrySet()) {
                    String string = path.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                    if (string.equals(remenberPath)) continue;
                    remenberPath = string;
                    arrayList.add(entry.getKey());
                }
                for (String string : arrayList) {
                    params.remove(string);
                }
                finalUrl = new Url(this.url + "/" + remenberPath);
                traceContext = Trace.get();
                if (traceContext != null) {
                    traceContext.start(finalUrl.toString(), VisitType.HTTP_SERVICE());
                    finalUrl.addParam(RemoteTraceElementKey.TRACEID(), traceContext.traceId());
                    finalUrl.addParam(RemoteTraceElementKey.RPCID(), traceContext.currentRpcId());
                }
                HttpTransportService.SResponse sResponse = null;
                message = null;
                try {
                    if (reqMethod.equals((Object)RestRequest.Method.GET)) {
                        HttpTransportService.SResponse sResponse2 = this.httpTransportService.get(finalUrl, params);
                    } else if (body == null) {
                        HttpTransportService.SResponse sResponse3 = this.httpTransportService.post(finalUrl, params);
                    } else {
                        finalUrl.query(this.encodeParams(params));
                        HttpTransportService.SResponse sResponse4 = this.httpTransportService.http(finalUrl, body, reqMethod);
                    }
                    responseStatus = -1;
                    responseLength = -1L;
                    if (var16_37 != null) {
                        responseStatus = var16_37.getStatus();
                    }
                    if (var16_37 == null) break block27;
                }
                catch (Exception e) {
                    message = ExceptionUtils.getStackTrace((Throwable)e).replaceAll("\n", "\\n");
                    break block28;
                }
                finally {
                    int responseStatus2 = -1;
                    long responseLength2 = -1L;
                    if (sResponse != null) {
                        responseStatus2 = sResponse.getStatus();
                    }
                    if (sResponse != null) {
                        responseLength2 = sResponse.getContent().length();
                    }
                    if (traceContext != null) {
                        traceContext.finish(responseStatus2, responseLength2, message, this.logger);
                    }
                }
                responseLength = var16_37.getContent().length();
            }
            if (traceContext != null) {
                traceContext.finish(responseStatus, responseLength, message, this.logger);
            }
        }
        if (var16_38 == null) {
            return new HttpTransportService.SResponse(-1, "network fail or timeout", finalUrl);
        }
        return var16_38;
    }
}

