/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Transient;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.jpa.JPA;
import net.csdn.jpa.association.Association;
import net.csdn.jpa.context.JPAConfig;
import net.csdn.jpa.context.JPAContext;
import net.csdn.jpa.model.GenericModel;
import net.csdn.modules.persist.mysql.DataSourceManager;
import net.csdn.modules.persist.mysql.MysqlClient;
import net.csdn.validate.ValidateParse;
import net.csdn.validate.ValidateResult;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;

public class JPABase
implements GenericModel {
    protected CSLogger logger = Loggers.getLogger(this.getClass());
    public static final List validateParses = WowCollections.list((Object[])new Object[0]);
    public static final MysqlClient mysqlClient = new MysqlClient(new DataSourceManager(JPA.settings()), JPA.settings());
    @Transient
    public final List<ValidateResult> validateResults = new ArrayList<ValidateResult>();

    public static JPAContext getJPAContext() {
        return JPABase.getJPAConfig().getJPAContext();
    }

    public static <T> T findService(Class<T> clz) {
        return (T)JPA.injector().getInstance(clz);
    }

    public Integer id() {
        return this.attr("id", Integer.class);
    }

    public static JPAConfig getJPAConfig() {
        return JPA.getJPAConfig();
    }

    public <T> T attr(String fieldName, Class<T> clzz) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return clzz.cast(field.get(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JPABase attr(String fieldName, Object value) {
        try {
            BeanUtils.setProperty((Object)this, (String)fieldName, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public <T extends JPABase> T m(String methodName, Object ... objs) {
        try {
            return (T)((JPABase)MethodUtils.invokeMethod((Object)this, (String)methodName, (Object[])objs));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Association associate(String obj) {
        return (Association)ReflectHelper.method((Object)this, (String)obj);
    }

    @Override
    public boolean save() {
        if (this.valid()) {
            this.em().persist((Object)this);
            this.em().flush();
            return true;
        }
        return false;
    }

    public boolean save(boolean validate) {
        if (validate && this.valid()) {
            this.em().persist((Object)this);
            this.em().flush();
            return true;
        }
        return false;
    }

    public boolean valid() {
        if (this.validateResults.size() > 0) {
            return false;
        }
        for (Object validateParse : validateParses) {
            ((ValidateParse)validateParse).parse(this, this.validateResults);
        }
        return this.validateResults.size() == 0;
    }

    public EntityManager em() {
        return JPABase.getJPAContext().em();
    }

    @Override
    public boolean refresh() {
        if (this.valid()) {
            this.em().refresh((Object)this);
            this.em().flush();
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        this.em().remove((Object)this);
        this.em().flush();
    }

    @Override
    public boolean update() {
        if (this.valid()) {
            this.em().merge((Object)this);
            this.em().flush();
            return true;
        }
        return false;
    }

    public boolean merge(Map params) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)params);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Object key() {
        return null;
    }
}

