/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.hql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.csdn.common.collections.WowCollections;
import net.csdn.jpa.hql.WowWhereParser;

public class WowJoinParser {
    public static final String HQL_JOIN_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    private Set<String> keywords = WowCollections.newHashSet((Object[])new String[]{"join fetch", "left join fetch", "right join fetch", "inner join fetch", "outer join fetch"});
    private Set columns = new HashSet();
    private String alias = "";
    private List<String> joinClauses = new ArrayList<String>();

    public WowJoinParser(Set columns, String alias) {
        this.columns = columns;
        this.alias = alias;
    }

    public void parse(String joins) {
        StringTokenizer tokens = new StringTokenizer(joins, HQL_JOIN_SEPARATORS, true);
        while (tokens.hasMoreElements()) {
            this.joinClauses.add(this.token(tokens.nextToken()));
        }
    }

    public String toHql() {
        return WowCollections.join(this.joinClauses);
    }

    private String token(String token) {
        String lcToken = token.toLowerCase().trim();
        if (lcToken.equals("left") || lcToken.equals("right") || lcToken.equals("inner") || lcToken.equals("outer") || lcToken.equals("inner")) {
            return token;
        }
        if (lcToken.equals("join")) {
            return token + " fetch";
        }
        String prefixName = WowWhereParser.root(token);
        if (this.columns.contains(prefixName)) {
            if (prefixName.equals(this.alias)) {
                return token;
            }
            return this.alias + "." + token;
        }
        return token;
    }
}

