/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.enhancer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.persistence.Inheritance;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import net.csdn.annotation.association.NotMapping;
import net.csdn.common.Strings;
import net.csdn.common.collections.WowCollections;
import tech.mlsql.common.utils.collect.Lists;
import tech.mlsql.common.utils.collect.Maps;
import tech.mlsql.common.utils.collect.Sets;

public class ModelClass {
    public static final String MODEL_CLASS_NAME = "net.csdn.jpa.model.Model";
    public static final Map<CtClass, ModelClass> CTModelClasses = Maps.newHashMap();
    public CtClass originClass;
    private List<String> skipFields = WowCollections.list((Object[])new String[0]);
    private List<ModelClass> children = Lists.newArrayList();
    private ModelClass parent = null;
    public static List<ModelClass> ROOTS = Lists.newArrayList();

    public ModelClass(CtClass originClass) {
        this.originClass = originClass;
        this.notMapping(originClass, this.skipFields);
    }

    public static ModelClass findModelClass(CtClass ctClass) {
        return CTModelClasses.get(ctClass);
    }

    public List<String> notMappings() {
        return this.skipFields;
    }

    public ModelClass addChild(ModelClass temp) {
        this.children.add(temp);
        return this;
    }

    public ModelClass parent(ModelClass temp) {
        this.parent = temp;
        return this;
    }

    public ModelClass parent() {
        return this.parent;
    }

    public boolean isLeafNode() {
        return this.children.size() == 0;
    }

    public List<ModelClass> findLeafNodes() {
        ArrayList<ModelClass> result = new ArrayList<ModelClass>();
        this.innerFindLeaf(this, result);
        return result;
    }

    private void innerFindLeaf(ModelClass modelClass, List<ModelClass> result) {
        for (ModelClass temp : modelClass.children) {
            if (temp.isLeafNode()) {
                result.add(temp);
                continue;
            }
            this.innerFindLeaf(temp, result);
        }
    }

    public List<ModelClass> children() {
        return this.children;
    }

    public static List<CtField> fields(CtClass tOriginClass, FieldFilter fieldFilter) {
        HashSet ctFields = Sets.newHashSet();
        for (CtField field : tOriginClass.getDeclaredFields()) {
            if (!fieldFilter.filter(field)) continue;
            ctFields.add(field);
        }
        int count = 0;
        try {
            CtClass ctClass;
            while (!(ctClass = tOriginClass.getSuperclass()).getClass().getName().equals(MODEL_CLASS_NAME)) {
                for (CtField field : ctClass.getDeclaredFields()) {
                    if (!fieldFilter.filter(field)) continue;
                    ctFields.add(field);
                }
                if (++count <= 5) continue;
                break;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return Lists.newArrayList((Iterable)ctFields);
    }

    public static CtMethod findTTMethod(CtClass clazz, String methodName, CtClass ... paramTypes) {
        CtClass superclass = clazz;
        try {
            return superclass.getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e2) {
            while (true) {
                try {
                    superclass = superclass.getSuperclass();
                    return superclass.getDeclaredMethod(methodName, paramTypes);
                }
                catch (Exception e) {
                    if (superclass != null && !Object.class.getName().equals(superclass.getName())) continue;
                    return null;
                }
                break;
            }
        }
    }

    public static List<CtMethod> findTTMethods(MethodFilter filter, CtClass clazz, String methodName) {
        if (filter == null) {
            filter = new MethodFilter(){

                @Override
                public boolean filter(CtMethod method) {
                    return true;
                }
            };
        }
        HashSet<CtMethod> methodSet = new HashSet<CtMethod>();
        CtClass superclass = clazz;
        for (CtMethod method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !filter.filter(method)) continue;
            methodSet.add(method);
        }
        do {
            try {
                superclass = superclass.getSuperclass();
                for (CtMethod method : superclass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || !filter.filter(method)) continue;
                    methodSet.add(method);
                }
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        } while (superclass != null && !Object.class.getName().equals(superclass.getName()));
        return Lists.newArrayList(methodSet);
    }

    public static boolean isInheritance(CtClass ct) {
        try {
            return ct.hasAnnotation(Inheritance.class) || Modifier.isAbstract((int)ct.getModifiers()) || !ct.getSuperclass().getClass().getName().equals(MODEL_CLASS_NAME);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static boolean isLeafClass(List<ModelClass> classes, CtClass ct) {
        if (ModelClass.isInheritance(ct)) {
            return false;
        }
        for (ModelClass modelClass : classes) {
            try {
                if (!modelClass.originClass.subtypeOf(ct)) continue;
                return false;
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void iterateSuperClass(CtClass ctClass, SuperClassIterator superClassIterator) {
        try {
            CtClass temp;
            int count = 0;
            while (!(temp = ctClass.getSuperclass()).getClass().getName().equals(MODEL_CLASS_NAME)) {
                superClassIterator.iterate(temp);
                if (++count <= 5) continue;
                break;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void notMapping(CtClass ctClass, List<String> skipFields) {
        if (ctClass.hasAnnotation(NotMapping.class)) {
            try {
                NotMapping notMapping = (NotMapping)ctClass.getAnnotation(NotMapping.class);
                for (String str : notMapping.value()) {
                    skipFields.add(Strings.toUnderscoreCase((String)str));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.autoNotMapping(ctClass, skipFields);
    }

    private void autoNotMapping(CtClass ctClass, final List<String> skipFields) {
        ModelClass.fields(ctClass, new FieldFilter(){

            @Override
            public boolean filter(CtField field) {
                ModelClass.this.guessNotMappingName(field, ManyToOne.class, skipFields);
                ModelClass.this.guessNotMappingName(field, OneToOne.class, skipFields);
                return false;
            }
        });
    }

    private void guessNotMappingName(CtField ctField, Class clzz, List<String> skipFields) {
        block5: {
            if (ctField.hasAnnotation(clzz)) {
                Method mappedBy = null;
                String tablePrefix = Strings.toUnderscoreCase((String)ctField.getName());
                try {
                    Object wow = ctField.getAnnotation(clzz);
                    mappedBy = wow.getClass().getMethod("mappedBy", new Class[0]);
                    String value = (String)mappedBy.invoke(wow, new Object[0]);
                    if (value == null || value.isEmpty()) {
                        skipFields.add(tablePrefix + "_id");
                        skipFields.add(Strings.toCamelCase((String)(tablePrefix + "_id"), (boolean)false));
                    } else {
                        skipFields.add(Strings.toUnderscoreCase((String)value));
                        skipFields.add(Strings.toCamelCase((String)value));
                    }
                }
                catch (Exception e) {
                    if (mappedBy != null) break block5;
                    skipFields.add(ctField.getName() + "_id");
                    skipFields.add(Strings.toCamelCase((String)(ctField.getName() + "_id"), (boolean)false));
                }
            }
        }
    }

    public static interface SuperClassIterator {
        public void iterate(CtClass var1);
    }

    public static interface MethodFilter {
        public boolean filter(CtMethod var1);
    }

    public static interface FieldFilter {
        public boolean filter(CtField var1);
    }
}

