/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.enhancer.association;

import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import net.csdn.annotation.association.ManyToManyHint;
import net.csdn.common.Strings;
import net.csdn.common.enhancer.EnhancerHelper;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.enhancer.AssociatedHelper;
import net.csdn.jpa.JPA;
import net.csdn.jpa.enhancer.ModelClass;
import net.csdn.jpa.type.DBInfo;

public class ManyToManyEnhancer {
    private ModelClass modelClass;

    public ManyToManyEnhancer(ModelClass modelClass) {
        this.modelClass = modelClass;
    }

    private void addManyToManyAnnotation(CtField ctField, CtField other, String tableName) {
        if (ctField.hasAnnotation(JoinTable.class)) {
            return;
        }
        ConstPool constPool = ctField.getFieldInfo2().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        for (Object temp : ctField.getFieldInfo().getAttributes()) {
            AttributeInfo info = (AttributeInfo)temp;
            if (!(info instanceof AnnotationsAttribute)) continue;
            attr = (AnnotationsAttribute)info;
        }
        Annotation joinTable = new Annotation(JoinTable.class.getName(), constPool);
        joinTable.addMemberValue("name", (MemberValue)new StringMemberValue(tableName, constPool));
        Annotation joinColumns = new Annotation(JoinColumn.class.getName(), constPool);
        joinColumns.addMemberValue("name", (MemberValue)new StringMemberValue(Strings.toUnderscoreCase((String)(other.getName() + "_id")), constPool));
        joinColumns.addMemberValue("referencedColumnName", (MemberValue)new StringMemberValue("id", constPool));
        ArrayMemberValue t1 = new ArrayMemberValue(constPool);
        t1.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(joinColumns, constPool)});
        joinTable.addMemberValue("joinColumns", (MemberValue)t1);
        Annotation inverseJoinColumns = new Annotation(JoinColumn.class.getName(), constPool);
        inverseJoinColumns.addMemberValue("name", (MemberValue)new StringMemberValue(Strings.toUnderscoreCase((String)(ctField.getName() + "_id")), constPool));
        inverseJoinColumns.addMemberValue("referencedColumnName", (MemberValue)new StringMemberValue("id", constPool));
        ArrayMemberValue t2 = new ArrayMemberValue(constPool);
        t2.setValue((MemberValue[])new AnnotationMemberValue[]{new AnnotationMemberValue(inverseJoinColumns, constPool)});
        joinTable.addMemberValue("inverseJoinColumns", (MemberValue)t2);
        attr.addAnnotation(joinTable);
    }

    public void enhancer() throws Exception {
        CtField[] fields;
        CtClass ctClass = this.modelClass.originClass;
        for (CtField ctField : fields = this.modelClass.originClass.getDeclaredFields()) {
            if (!EnhancerHelper.hasAnnotation((CtField)ctField, (String)"javax.persistence.ManyToMany")) continue;
            String clzzName = AssociatedHelper.findAssociatedClassName(ctField);
            String mappedByFieldName = AssociatedHelper.findAssociatedFieldName(this.modelClass, clzzName);
            String mappedByClassName = ctClass.getName();
            CtField other = AssociatedHelper.findAssociatedField(this.modelClass, clzzName);
            DBInfo dbInfo = JPA.dbInfo();
            String otherClassSimpleName = AssociatedHelper.findAssociatedClass(ctClass.getClassPool(), ctField).getSimpleName();
            String maybeTable1 = Strings.toUnderscoreCase((String)ctClass.getSimpleName()) + "_" + Strings.toUnderscoreCase((String)otherClassSimpleName);
            String maybeTable2 = Strings.toUnderscoreCase((String)otherClassSimpleName) + "_" + Strings.toUnderscoreCase((String)ctClass.getSimpleName());
            String finalTableName = dbInfo.tableNames.contains(maybeTable1) ? maybeTable1 : maybeTable2;
            AssociatedHelper.setCascadeWithDefault(ctField, "ManyToMany");
            boolean isMaster = false;
            if (!ctField.hasAnnotation(ManyToManyHint.class)) {
                if (dbInfo.tableNames.contains(maybeTable1)) {
                    AssociatedHelper.setMappedBy(other, ctField.getName(), "ManyToMany");
                    isMaster = true;
                    finalTableName = maybeTable1;
                    this.addManyToManyAnnotation(ctField, other, maybeTable1);
                }
                if (dbInfo.tableNames.contains(maybeTable2)) {
                    AssociatedHelper.setMappedBy(ctField, mappedByFieldName, "ManyToMany");
                    finalTableName = maybeTable2;
                    this.addManyToManyAnnotation(other, ctField, maybeTable2);
                }
                AssociatedHelper.setManyToManyHint(other);
            }
            AssociatedHelper.findAndRemoveMethod(ctClass, ctField, mappedByClassName);
            AssociatedHelper.findAndRemoveMethod(ctClass, ctField.getName());
            String propertyName = mappedByFieldName.substring(0, 1).toUpperCase() + mappedByFieldName.substring(1);
            String getter = "get" + propertyName;
            CtMethod ctMethod = ModelClass.findTTMethod(ctClass, ctField.getName(), new CtClass[0]);
            if (ctMethod != null) {
                ctMethod.setModifiers(2);
            }
            if ((ctMethod = ModelClass.findTTMethod(ctClass, ctField.getName(), ctField.getType())) != null) {
                ctMethod.setModifiers(2);
            }
            CtMethod wow = CtMethod.make((String)MessageFormat.format((String)"public net.csdn.jpa.association.Association {}() {net.csdn.jpa.association.Association obj = new net.csdn.jpa.association.Association(this,\"{}\",\"{}\",\"{}\",\"{}\",\"{}\");return obj;    }", (Object[])new Object[]{ctField.getName(), ctField.getName(), mappedByFieldName, "javax.persistence.ManyToMany", finalTableName, isMaster}), (CtClass)ctClass);
            ctClass.addMethod(wow);
            CtMethod wow2 = CtMethod.make((String)MessageFormat.format((String)"public {} {}({} obj) {        {}.add(obj);        obj.{}().add(this);        return this;    }", (Object[])new Object[]{ctClass.getName(), ctField.getName(), clzzName, ctField.getName(), getter}), (CtClass)ctClass);
            ctClass.addMethod(wow2);
        }
    }
}

