/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.association;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import net.csdn.common.Strings;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.jpa.JPA;
import net.csdn.jpa.model.JPABase;
import net.csdn.jpa.model.JPQL;
import net.csdn.jpa.model.Model;

public class Association {
    private JPABase object;
    private JPABase targetObject;
    private String field;
    private String targetField;
    private String type;
    private String tableName;
    private boolean master;

    public Association(Model object, String field, String targetField, String type) {
        this.object = object;
        this.field = field;
        this.targetField = targetField;
        this.type = type;
    }

    public Association(Model object, String field, String targetField, String type, String tableName, String master) {
        this(object, field, targetField, type);
        this.tableName = tableName;
        this.master = Boolean.parseBoolean(master);
    }

    private EntityManager em() {
        return JPA.getJPAConfig().getJPAContext().em();
    }

    public void remove(JPABase model) {
        this.targetObject = model;
        try {
            if (this.type.equals("javax.persistence.ManyToMany")) {
                String idFiled1 = Strings.toUnderscoreCase((String)this.field) + "_id";
                String idFiled2 = Strings.toUnderscoreCase((String)this.targetField) + "_id";
                this.em().createNativeQuery(MessageFormat.format((String)("delete from " + this.tableName + " where {}={} and {}={}"), (Object[])new Object[]{idFiled1, this.targetObject.id(), idFiled2, this.object.id()})).executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List fetch() {
        return this.jpql().fetch();
    }

    public long count() {
        return this.jpql().count_fetch();
    }

    public long count(String countStr) {
        return this.jpql().count_fetch(countStr);
    }

    private Class getTargetModelClass() {
        try {
            Field tempField = this.object.getClass().getDeclaredField(this.field);
            Class clzz = tempField.getType();
            if (clzz.getSuperclass() != Model.class) {
                clzz = (Class)((ParameterizedType)tempField.getGenericType()).getActualTypeArguments()[0];
            }
            return clzz;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JPQL jpql() {
        JPQL jpql = null;
        if (this.type.equals("javax.persistence.ManyToMany") || this.type.equals("javax.persistence.ManyToOne")) {
            jpql = (JPQL)ReflectHelper.staticMethod((Class)this.getTargetModelClass(), (String)"joins", (Object[])new Object[]{this.targetField + " as framework_service_holder_" + this.targetField});
        }
        if (jpql != null) {
            jpql.where(WowCollections.map((Object[])new Object[]{"framework_service_holder_" + this.targetField, this.object}));
        } else {
            jpql = (JPQL)ReflectHelper.staticMethod((Class)this.getTargetModelClass(), (String)"where", (Object[])new Object[]{this.targetField + "=:framework_service_holder", WowCollections.map((Object[])new Object[]{"framework_service_holder", this.object})});
        }
        return jpql;
    }

    public JPQL where(String where, Map<String, Object> params) {
        return this.jpql().where(where, params);
    }

    public JPQL where(String where) {
        return this.where(where, WowCollections.map((Object[])new Object[0]));
    }

    public JPQL where(Map whereQuery) {
        return this.jpql().where(whereQuery);
    }

    public JPQL order(String orderBy) {
        return this.jpql().order(orderBy);
    }

    public JPQL offset(Integer offset) {
        return this.jpql().offset(offset);
    }

    public JPQL limit(Integer limit) {
        return this.jpql().limit(limit);
    }

    public void delete() {
        if (!this.master) {
            try {
                EntityManager entityManager = JPA.getJPAConfig().getJPAContext().em();
                if (this.type.equals("javax.persistence.ManyToMany")) {
                    String idFiled1 = Strings.toUnderscoreCase((String)(this.field + "_id"));
                    entityManager.createNativeQuery(MessageFormat.format((String)("delete from " + this.tableName + " where  {}={}"), (Object[])new Object[]{idFiled1, this.object.id()})).executeUpdate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.object.delete();
    }

    public boolean set(JPABase model) {
        return this.add(model);
    }

    public boolean add(Map params) {
        try {
            return this.add((JPABase)ReflectHelper.staticMethod((Class)this.getTargetModelClass(), (String)"create", (Object[])new Object[]{params}));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean add(JPABase model) {
        this.targetObject = model;
        try {
            if (this.type.equals("javax.persistence.OneToMany")) {
                this.object.attr(this.field, Collection.class).add(this.targetObject);
                this.targetObject.attr(this.targetField, this.object);
            }
            if (this.type.equals("javax.persistence.OneToOne")) {
                this.object.attr(this.field, this.targetObject);
                this.targetObject.attr(this.targetField, this.object);
            }
            if (this.type.equals("javax.persistence.ManyToOne")) {
                this.object.attr(this.field, this.targetObject);
                this.targetObject.attr(this.targetField, Collection.class).add(this.object);
            }
            if (this.type.equals("javax.persistence.ManyToMany")) {
                this.object.attr(this.field, Collection.class).add(this.targetObject);
                this.targetObject.attr(this.targetField, Collection.class).add(this.object);
            }
            return this.targetObject.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

