/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.path;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.csdn.common.collect.MapBuilder;

public class PathTrie<T> {
    private final TrieNode<T> root;
    private final Pattern pattern;
    private T rootValue;

    public PathTrie() {
        this("/", "*");
    }

    public PathTrie(String separator, String wildcard) {
        this.pattern = Pattern.compile(separator);
        this.root = new TrieNode<Object>(separator, null, null, wildcard);
    }

    public void insert(String path, T value) {
        String[] strings = this.pattern.split(path);
        if (strings.length == 0) {
            this.rootValue = value;
            return;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insert(strings, index, value);
    }

    public T retrieve(String path) {
        return this.retrieve(path, null);
    }

    public T retrieve(String path, Map<String, String> params) {
        if (path.length() == 0) {
            return this.rootValue;
        }
        String[] strings = this.pattern.split(path);
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        return this.root.retrieve(strings, index, params);
    }

    public class TrieNode<T> {
        private transient String key;
        private transient T value;
        private boolean isWildcard;
        private final String wildcard;
        private transient String namedWildcard;
        private ImmutableMap<String, TrieNode<T>> children;
        private final TrieNode parent;

        public TrieNode(String key, T value, TrieNode parent, String wildcard) {
            this.key = key;
            this.wildcard = wildcard;
            this.isWildcard = key.equals(wildcard);
            this.parent = parent;
            this.value = value;
            this.children = ImmutableMap.of();
            this.namedWildcard = this.isNamedWildcard(key) ? key.substring(key.indexOf(123) + 1, key.indexOf(125)) : null;
        }

        public synchronized void addChild(TrieNode<T> child) {
            this.children = MapBuilder.newMapBuilder(this.children).put(child.key, child).immutableMap();
        }

        public TrieNode getChild(String key) {
            return (TrieNode)this.children.get((Object)key);
        }

        public synchronized void insert(String[] path, int index, T value) {
            TrieNode<Object> node;
            String token;
            if (index >= path.length) {
                return;
            }
            String key = token = path[index];
            if (this.isNamedWildcard(token)) {
                key = this.wildcard;
            }
            if ((node = (TrieNode<T>)this.children.get((Object)key)) == null) {
                node = index == path.length - 1 ? new TrieNode<T>(token, value, this, this.wildcard) : new TrieNode<Object>(token, null, this, this.wildcard);
                this.children = MapBuilder.newMapBuilder(this.children).put(key, node).immutableMap();
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index == path.length - 1) {
                    assert (node.value == null || node.value == value);
                    if (node.value == null) {
                        node.value = value;
                    }
                }
            }
            node.insert(path, index + 1, value);
        }

        public T retrieve(String[] path, int index, Map<String, String> params) {
            if (index >= path.length) {
                return null;
            }
            String token = path[index];
            TrieNode node = (TrieNode)this.children.get((Object)token);
            boolean usedWildcard = false;
            if (node == null) {
                node = (TrieNode)this.children.get((Object)this.wildcard);
                if (node == null) {
                    return null;
                }
                usedWildcard = true;
                if (params != null && node.isNamedWildcard()) {
                    this.put(params, node.namedWildcard(), token);
                }
            }
            if (index == path.length - 1) {
                return node.value;
            }
            T res = node.retrieve(path, index + 1, params);
            if (res == null && !usedWildcard && (node = (TrieNode)this.children.get((Object)this.wildcard)) != null) {
                if (params != null && node.isNamedWildcard()) {
                    this.put(params, node.namedWildcard(), token);
                }
                res = node.retrieve(path, index + 1, params);
            }
            return res;
        }

        private void put(Map<String, String> params, String key, String value) {
            params.put(key, value);
        }

        public void updateKeyWithNamedWildcard(String key) {
            this.key = key;
            this.namedWildcard = key.substring(key.indexOf(123) + 1, key.indexOf(125));
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }

        private boolean isNamedWildcard(String key) {
            return key.indexOf(123) != -1 && key.indexOf(125) != -1;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }
    }
}

