/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging.log4j;

import net.csdn.common.logging.log4j.Log4jFactory;
import net.csdn.common.logging.support.AbstractCSLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jCSLogger
extends AbstractCSLogger {
    private final Logger logger;

    public Log4jCSLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isHadooEnabled() {
        return this.logger.isEnabledFor((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL);
    }

    @Override
    protected void internalHadoo(String msg) {
        this.logger.log((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL, (Object)msg);
    }

    @Override
    protected void internalHadoo(String msg, Throwable cause) {
        this.logger.log((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL, (Object)msg, cause);
    }

    @Override
    protected void internalTrace(String msg) {
        this.logger.trace((Object)msg);
    }

    @Override
    protected void internalTrace(String msg, Throwable cause) {
        this.logger.trace((Object)msg, cause);
    }

    @Override
    protected void internalDebug(String msg) {
        this.logger.debug((Object)msg);
    }

    @Override
    protected void internalDebug(String msg, Throwable cause) {
        this.logger.debug((Object)msg, cause);
    }

    @Override
    protected void internalInfo(String msg) {
        this.logger.info((Object)msg);
    }

    @Override
    protected void internalInfo(String msg, Throwable cause) {
        this.logger.info((Object)msg, cause);
    }

    @Override
    protected void internalWarn(String msg) {
        this.logger.warn((Object)msg);
    }

    @Override
    protected void internalWarn(String msg, Throwable cause) {
        this.logger.warn((Object)msg, cause);
    }

    @Override
    protected void internalError(String msg) {
        this.logger.error((Object)msg);
    }

    @Override
    protected void internalError(String msg, Throwable cause) {
        this.logger.error((Object)msg, cause);
    }
}

