/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging.log4j;

import java.lang.reflect.Field;
import jline.ANSIBuffer;
import net.csdn.common.jline.ANSI;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class JLinePatternLayout
extends PatternLayout {
    protected PatternParser createPatternParser(String pattern) {
        try {
            return new JLinePatternParser(pattern);
        }
        catch (Throwable t) {
            return super.createPatternParser(pattern);
        }
    }

    private static final class JLinePatternParser
    extends PatternParser {
        private JLinePatternParser(String pattern) {
            super(pattern);
        }

        protected void addConverter(PatternConverter pc) {
            try {
                if (ANSI.isEnabled() && pc.getClass().getName().endsWith("BasicPatternConverter")) {
                    Field typeField = pc.getClass().getDeclaredField("type");
                    typeField.setAccessible(true);
                    Integer type = (Integer)typeField.get(pc);
                    if (type == 2002) {
                        pc = new ColoredLevelPatternConverter(this.formattingInfo);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.addConverter(pc);
        }

        private static class ColoredLevelPatternConverter
        extends PatternConverter {
            ColoredLevelPatternConverter(FormattingInfo formattingInfo) {
                super(formattingInfo);
            }

            public String convert(LoggingEvent event) {
                if (!ANSI.isEnabled()) {
                    return event.getLevel().toString();
                }
                if (event.getLevel() == Level.FATAL) {
                    return ANSIBuffer.ANSICodes.attrib((int)31) + event.getLevel().toString() + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                if (event.getLevel() == Level.ERROR) {
                    return ANSIBuffer.ANSICodes.attrib((int)31) + event.getLevel().toString() + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                if (event.getLevel() == Level.WARN) {
                    return ANSIBuffer.ANSICodes.attrib((int)33) + event.getLevel().toString() + ' ' + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                if (event.getLevel() == Level.INFO) {
                    return ANSIBuffer.ANSICodes.attrib((int)32) + event.getLevel().toString() + ' ' + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                if (event.getLevel() == Level.DEBUG) {
                    return ANSIBuffer.ANSICodes.attrib((int)36) + event.getLevel().toString() + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                if (event.getLevel() == Level.TRACE) {
                    return ANSIBuffer.ANSICodes.attrib((int)34) + event.getLevel().toString() + ANSIBuffer.ANSICodes.attrib((int)0);
                }
                return event.getLevel().toString();
            }
        }
    }
}

