/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.io;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;

    public static long copy(File in, File out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input File specified");
        Preconditions.checkNotNull((Object)out, (Object)"No output File specified");
        return Streams.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input byte array specified");
        Preconditions.checkNotNull((Object)out, (Object)"No output File specified");
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        Streams.copy(inStream, (OutputStream)outStream);
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No InputStream specified");
        Preconditions.checkNotNull((Object)out, (Object)"No OutputStream specified");
        try {
            int bytesRead;
            long byteCount = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
            long l = byteCount;
            return l;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copyToByteArray(InputStream in) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No InputStream specified");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[6144];
        try {
            int bytesRead;
            long byteCount = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input byte array specified");
        Preconditions.checkNotNull((Object)out, (Object)"No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No Reader specified");
        Preconditions.checkNotNull((Object)out, (Object)"No Writer specified");
        try {
            int bytesRead;
            int byteCount = 0;
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"No input String specified");
        Preconditions.checkNotNull((Object)out, (Object)"No Writer specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, (Writer)out);
        return out.toString();
    }

    public static String copyToStringFromClasspath(ClassLoader classLoader, String path) throws IOException {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath with class loader [" + classLoader + "]");
        }
        return Streams.copyToString(new InputStreamReader(is, "UTF-8"));
    }

    public static String copyToStringFromClasspath(String path) throws IOException {
        InputStream is = Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        return Streams.copyToString(new InputStreamReader(is));
    }
}

