/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.util;

import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class PathResolvingUtil {
    private static final String PATH_SEPARATOR = ".";
    private static final String PATH_REGEX = "\\.";
    private static final String CLASS_ATTRIBUTE_NAME = "class";

    private PathResolvingUtil() {
    }

    public static String[] convertToPathList(String path) {
        return path.split(PATH_REGEX);
    }

    public static String joinPath(String ... pathList) {
        return String.join((CharSequence)PATH_SEPARATOR, pathList);
    }

    public static String joinPath(List<String> pathList, String currentPath) {
        ArrayList<String> fullPathList = new ArrayList<String>(pathList);
        fullPathList.add(currentPath);
        return String.join((CharSequence)PATH_SEPARATOR, fullPathList);
    }

    public static String removeFirstPathElement(String[] path) {
        return String.join((CharSequence)PATH_SEPARATOR, Arrays.copyOfRange(path, 1, path.length));
    }

    public static Path<?> calculateFullPath(Path<?> rootPath, JoinType defaultJoinType, String[] pathList) {
        JoinType calculatedJoinPath = Optional.ofNullable(defaultJoinType).orElse(JoinType.INNER);
        Path calculatedPath = rootPath;
        for (String currentPathSegment : pathList) {
            if (PathResolvingUtil.shouldJoinPath(calculatedPath, currentPathSegment)) {
                From from = (From)calculatedPath;
                calculatedPath = (Path)from.getJoins().stream().filter(join -> currentPathSegment.equals(join.getAttribute().getName())).findFirst().orElseGet(() -> from.join(currentPathSegment, calculatedJoinPath));
                continue;
            }
            calculatedPath = calculatedPath.get(currentPathSegment);
        }
        return calculatedPath;
    }

    private static boolean shouldJoinPath(Path<?> calculatedPath, String currentPathSegment) {
        if (CLASS_ATTRIBUTE_NAME.equals(currentPathSegment)) {
            return false;
        }
        Bindable bindable = calculatedPath.getModel();
        if (bindable instanceof EntityType) {
            EntityType entityType = (EntityType)bindable;
            Attribute attribute = entityType.getAttribute(currentPathSegment);
            return attribute.isCollection() || attribute.isAssociation();
        }
        return false;
    }
}

