/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.support;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.Generated;
import net.croz.nrich.search.model.AttributeHolder;
import net.croz.nrich.search.util.PathResolvingUtil;
import org.springframework.util.Assert;

public class JpaEntityAttributeResolver {
    private final ManagedType<?> managedType;

    public AttributeHolder resolveAttributeByPath(String path) {
        Assert.notNull((Object)path, (String)"Path must be defined when searching for attribute!");
        String[] pathList = PathResolvingUtil.convertToPathList(path);
        Attribute<?, ?> attribute = this.resolveAttributeByName(this.managedType, pathList[0]);
        boolean isPlural = attribute instanceof PluralAttribute;
        ManagedType<?> currentManagedType = this.resolveManagedTypeFromAttribute(attribute);
        if (currentManagedType != null && pathList.length > 1) {
            String[] restOfPathList;
            for (String currentPath : restOfPathList = Arrays.copyOfRange(pathList, 1, pathList.length)) {
                if (currentManagedType == null) {
                    attribute = null;
                    isPlural = false;
                    break;
                }
                attribute = this.resolveAttributeByName(currentManagedType, currentPath);
                currentManagedType = this.resolveManagedTypeFromAttribute(attribute);
                isPlural |= attribute instanceof PluralAttribute;
            }
        }
        return new AttributeHolder(attribute, currentManagedType, isPlural);
    }

    private ManagedType<?> resolveManagedTypeFromAttribute(Attribute<?, ?> attribute) {
        ManagedType currentManagedType = null;
        if (attribute instanceof SingularAttribute && ((SingularAttribute)attribute).getType() instanceof ManagedType) {
            currentManagedType = (ManagedType)((SingularAttribute)attribute).getType();
        } else if (attribute instanceof PluralAttribute && ((PluralAttribute)attribute).getElementType() instanceof ManagedType) {
            currentManagedType = (ManagedType)((PluralAttribute)attribute).getElementType();
        }
        return currentManagedType;
    }

    private Attribute<?, ?> resolveAttributeByName(ManagedType<?> managedType, String attributeName) {
        try {
            return managedType.getAttribute(attributeName);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Generated
    public ManagedType<?> getManagedType() {
        return this.managedType;
    }

    @ConstructorProperties(value={"managedType"})
    @Generated
    public JpaEntityAttributeResolver(ManagedType<?> managedType) {
        this.managedType = managedType;
    }
}

