/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.ManagedType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.croz.nrich.search.api.converter.StringToEntityPropertyMapConverter;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.repository.StringSearchExecutor;
import net.croz.nrich.search.support.JpaQueryBuilder;
import net.croz.nrich.search.util.QueryUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaStringSearchExecutor<T>
implements StringSearchExecutor<T> {
    private final StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter;
    private final EntityManager entityManager;
    private final Class<T> domainClass;
    private final JpaQueryBuilder<T> queryBuilder;
    private final ManagedType<?> managedType;

    public JpaStringSearchExecutor(StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter, EntityManager entityManager, JpaEntityInformation<T, ?> jpaEntityInformation) {
        this.stringToEntityPropertyMapConverter = stringToEntityPropertyMapConverter;
        this.entityManager = entityManager;
        this.domainClass = jpaEntityInformation.getJavaType();
        this.queryBuilder = new JpaQueryBuilder(entityManager, jpaEntityInformation.getJavaType());
        this.managedType = jpaEntityInformation.getRequiredIdAttribute().getDeclaringType();
    }

    public <P> Optional<P> findOne(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted());
        try {
            return Optional.of(this.entityManager.createQuery(query).getSingleResult());
        }
        catch (NoResultException ignored) {
            return Optional.empty();
        }
    }

    public <P> List<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted());
        return this.entityManager.createQuery(query).getResultList();
    }

    public <P> List<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration, Sort sort) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, sort);
        return this.entityManager.createQuery(query).getResultList();
    }

    public <P> Page<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration, Pageable pageable) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        if (pageable.isPaged()) {
            typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
            return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(searchMap, searchConfiguration));
        }
        return new PageImpl(typedQuery.getResultList());
    }

    public <P> long count(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        return this.executeCountQuery(searchMap, searchConfiguration);
    }

    public <P> boolean exists(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList, searchConfiguration);
        CriteriaQuery<Integer> query = this.queryBuilder.buildExistsQuery(searchMap, searchConfiguration);
        return this.entityManager.createQuery(query).setMaxResults(1).getResultList().size() == 1;
    }

    public Class<T> getDomainClass() {
        return this.domainClass;
    }

    private Map<String, Object> convertToMap(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, ?, Map<String, Object>> searchConfiguration) {
        return this.stringToEntityPropertyMapConverter.convert(searchTerm, propertyToSearchList, this.managedType, searchConfiguration.getSearchPropertyConfiguration());
    }

    private <P> long executeCountQuery(Map<String, Object> searchMap, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        CriteriaQuery<Long> countQuery = this.queryBuilder.buildCountQuery(searchMap, searchConfiguration);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return QueryUtil.toCountResult(totals);
    }
}

