/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.List;
import java.util.Optional;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.repository.SearchExecutor;
import net.croz.nrich.search.support.JpaQueryBuilder;
import net.croz.nrich.search.util.QueryUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaSearchExecutor<T>
implements SearchExecutor<T> {
    private final EntityManager entityManager;
    private final Class<T> domainClass;
    private final JpaQueryBuilder<T> queryBuilder;

    public JpaSearchExecutor(EntityManager entityManager, JpaEntityInformation<T, ?> entityInformation) {
        this.entityManager = entityManager;
        this.domainClass = entityInformation.getJavaType();
        this.queryBuilder = new JpaQueryBuilder(entityManager, entityInformation.getJavaType());
    }

    public <R, P> Optional<P> findOne(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted());
        try {
            return Optional.of(this.entityManager.createQuery(query).getSingleResult());
        }
        catch (NoResultException ignored) {
            return Optional.empty();
        }
    }

    public <R, P> List<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted());
        return this.entityManager.createQuery(query).getResultList();
    }

    public <R, P> List<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration, Sort sort) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, sort);
        return this.entityManager.createQuery(query).getResultList();
    }

    public <R, P> Page<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration, Pageable pageable) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        if (pageable.isPaged()) {
            typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
            return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(request, searchConfiguration));
        }
        return new PageImpl(typedQuery.getResultList());
    }

    public <R, P> long count(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        return this.executeCountQuery(request, searchConfiguration);
    }

    public <R, P> boolean exists(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<Integer> query = this.queryBuilder.buildExistsQuery(request, searchConfiguration);
        return this.entityManager.createQuery(query).setMaxResults(1).getResultList().size() == 1;
    }

    public Class<T> getDomainClass() {
        return this.domainClass;
    }

    private <R, P> long executeCountQuery(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<Long> countQuery = this.queryBuilder.buildCountQuery(request, searchConfiguration);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return QueryUtil.toCountResult(totals);
    }
}

