/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.util;

import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PathResolvingUtil {
    private static final String PATH_SEPARATOR = ".";
    private static final String PATH_REGEX = "\\.";

    private PathResolvingUtil() {
    }

    public static String[] convertToPathList(String path) {
        return path.split(PATH_REGEX);
    }

    public static String joinPath(String ... pathList) {
        return String.join((CharSequence)PATH_SEPARATOR, pathList);
    }

    public static String joinPath(List<String> pathList, String currentPath) {
        ArrayList<String> fullPathList = new ArrayList<String>(pathList);
        fullPathList.add(currentPath);
        return String.join((CharSequence)PATH_SEPARATOR, fullPathList);
    }

    public static String removeFirstPathElement(String[] path) {
        return String.join((CharSequence)PATH_SEPARATOR, Arrays.copyOfRange(path, 1, path.length));
    }

    public static Path<?> calculateFullRestrictionPath(Path<?> rootPath, String[] pathList) {
        return PathResolvingUtil.calculateFullPath(rootPath, pathList, false);
    }

    public static Path<?> calculateFullSelectionPath(Path<?> rootPath, String[] pathList) {
        return PathResolvingUtil.calculateFullPath(rootPath, pathList, true);
    }

    private static Path<?> calculateFullPath(Path<?> rootPath, String[] pathList, boolean isSelection) {
        int lastElementIndex = pathList.length - 1;
        Object calculatedPath = rootPath;
        for (int i = 0; i < pathList.length; ++i) {
            calculatedPath = isSelection || i == lastElementIndex ? calculatedPath.get(pathList[i]) : ((From)calculatedPath).join(pathList[i]);
        }
        return calculatedPath;
    }
}

