/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.ManagedType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.search.api.model.AdditionalRestrictionResolver;
import net.croz.nrich.search.api.model.PluralAssociationRestrictionType;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.model.SearchJoin;
import net.croz.nrich.search.api.model.SearchProjection;
import net.croz.nrich.search.api.model.property.SearchPropertyConfiguration;
import net.croz.nrich.search.api.model.property.SearchPropertyJoin;
import net.croz.nrich.search.api.model.subquery.SubqueryConfiguration;
import net.croz.nrich.search.model.Restriction;
import net.croz.nrich.search.model.SearchDataParserConfiguration;
import net.croz.nrich.search.parser.SearchDataParser;
import net.croz.nrich.search.util.PathResolvingUtil;
import net.croz.nrich.search.util.ProjectionListResolverUtil;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JpaQueryBuilder<T> {
    private final EntityManager entityManager;
    private final Class<T> entityType;

    public <R, P> CriteriaQuery<P> buildQuery(R request, SearchConfiguration<T, P, R> searchConfiguration, Sort sort) {
        List<Selection<?>> projectionList;
        this.validateArguments(request, searchConfiguration);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<T> rootEntity = this.resolveRootEntity(request, searchConfiguration);
        Class<P> resultClass = this.resolveResultClass(searchConfiguration, rootEntity);
        Assert.isTrue((!this.joinFetchExists(searchConfiguration.getJoinList()) || this.entityType.isAssignableFrom(resultClass) ? 1 : 0) != 0, (String)"Join Fetch is ony possible when result class is not an projection!");
        CriteriaQuery query = criteriaBuilder.createQuery(resultClass);
        Root root = query.from(rootEntity);
        this.applyJoinsOrFetchesToQuery(true, request, root, searchConfiguration.getJoinList());
        List searchProjectionList = searchConfiguration.getProjectionList();
        if (!resultClass.equals(this.entityType) && CollectionUtils.isEmpty((Collection)searchProjectionList)) {
            searchProjectionList = ProjectionListResolverUtil.resolveSearchProjectionList(resultClass);
        }
        if (!CollectionUtils.isEmpty(projectionList = this.resolveQueryProjectionList(root, searchProjectionList, request))) {
            query.multiselect(projectionList);
        }
        query.distinct(searchConfiguration.isDistinct());
        this.resolveAndApplyPredicateList(request, searchConfiguration, criteriaBuilder, root, query);
        if (sort != null && sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder));
        }
        return query;
    }

    public <R, P> CriteriaQuery<Long> buildCountQuery(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        this.validateArguments(request, searchConfiguration);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<T> rootEntity = this.resolveRootEntity(request, searchConfiguration);
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(rootEntity);
        this.applyJoinsOrFetchesToQuery(false, request, root, searchConfiguration.getJoinList());
        if (searchConfiguration.isDistinct()) {
            query.select((Selection)criteriaBuilder.countDistinct((Expression)root));
        } else {
            query.select((Selection)criteriaBuilder.count((Expression)root));
        }
        CriteriaQuery castedQuery = query;
        this.resolveAndApplyPredicateList(request, searchConfiguration, criteriaBuilder, root, castedQuery);
        return query;
    }

    public <R, P> CriteriaQuery<Integer> buildExistsQuery(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        this.validateArguments(request, searchConfiguration);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<T> rootEntity = this.resolveRootEntity(request, searchConfiguration);
        CriteriaQuery query = criteriaBuilder.createQuery(Integer.class);
        Root root = query.from(rootEntity);
        this.applyJoinsOrFetchesToQuery(false, request, root, searchConfiguration.getJoinList());
        query.select((Selection)this.entityManager.getCriteriaBuilder().literal((Object)1));
        CriteriaQuery castedQuery = query;
        this.resolveAndApplyPredicateList(request, searchConfiguration, criteriaBuilder, root, castedQuery);
        return query;
    }

    private <R, P> void validateArguments(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        Assert.notNull(request, (String)"Search request is not defined!");
        Assert.notNull(searchConfiguration, (String)"Search configuration is not defined!");
    }

    private <R, P> Class<T> resolveRootEntity(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        Class rootEntity = searchConfiguration.getRootEntityResolver() == null ? this.entityType : (Class)searchConfiguration.getRootEntityResolver().apply(request);
        Assert.notNull((Object)rootEntity, (String)"Root entity returned by resolver is not defined!");
        return rootEntity;
    }

    private <R, P> Class<P> resolveResultClass(SearchConfiguration<T, P, R> searchConfiguration, Class<T> rootEntity) {
        return searchConfiguration.getResultClass() == null ? rootEntity : searchConfiguration.getResultClass();
    }

    private <R> void applyJoinsOrFetchesToQuery(boolean applyFetch, R request, Root<?> root, List<SearchJoin<R>> joinList) {
        if (CollectionUtils.isEmpty(joinList)) {
            return;
        }
        HashMap existingFetches = new HashMap();
        HashMap existingJoins = new HashMap();
        joinList.stream().filter(join -> this.shouldApplyJoinOrFetch((SearchJoin)join, request)).forEach(searchJoin -> this.applyJoinOrJoinFetch(existingFetches, existingJoins, root, (SearchJoin<?>)searchJoin, applyFetch));
    }

    private <R> List<Selection<?>> resolveQueryProjectionList(Root<?> root, List<SearchProjection<R>> projectionList, R request) {
        if (CollectionUtils.isEmpty(projectionList)) {
            return Collections.emptyList();
        }
        return projectionList.stream().filter(projection -> this.shouldApplyProjection((SearchProjection)projection, request)).map(projection -> this.convertToSelectionExpression((Path<?>)root, (SearchProjection)projection)).collect(Collectors.toList());
    }

    private <R> boolean shouldApplyJoinOrFetch(SearchJoin<R> join, R request) {
        return join.getCondition() == null || join.getCondition().test(request);
    }

    private void applyJoinOrJoinFetch(Map<String, Fetch<?, ?>> existingFetches, Map<String, Join<?, ?>> existingJoins, Root<?> root, SearchJoin<?> searchJoin, boolean applyFetch) {
        JoinType joinType = searchJoin.getJoinType() == null ? JoinType.INNER : searchJoin.getJoinType();
        String[] pathList = PathResolvingUtil.convertToPathList(searchJoin.getPath());
        if (applyFetch && searchJoin.isFetch()) {
            this.applyJoinOrFetch(existingFetches, pathList, (path, fetch) -> fetch == null ? root.fetch(path, joinType) : fetch.fetch(path, joinType));
        } else {
            this.applyJoinOrFetch(existingJoins, pathList, (path, join) -> join == null ? root.join(path, joinType) : ((Join)join).join(path, joinType));
        }
    }

    private <E> void applyJoinOrFetch(Map<String, E> existingJoinsOrFetches, String[] pathList, BiFunction<String, FetchParent<?, ?>, E> pathFunction) {
        Object joinOrFetch = null;
        String currentPath = null;
        for (String path : pathList) {
            String string = currentPath = currentPath == null ? path : PathResolvingUtil.joinPath(currentPath, path);
            if (existingJoinsOrFetches.containsKey(currentPath)) {
                joinOrFetch = existingJoinsOrFetches.get(currentPath);
                continue;
            }
            joinOrFetch = pathFunction.apply(path, (FetchParent)joinOrFetch);
            existingJoinsOrFetches.put(currentPath, joinOrFetch);
        }
    }

    private <R> boolean shouldApplyProjection(SearchProjection<R> projection, R request) {
        return projection.getCondition() == null || projection.getCondition().test(request);
    }

    private <P, R> void resolveAndApplyPredicateList(R request, SearchConfiguration<T, P, R> searchConfiguration, CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<P> query) {
        List<Predicate> requestPredicateList = this.resolveQueryPredicateList(request, searchConfiguration, criteriaBuilder, root, query);
        List<Predicate> interceptorPredicateList = this.resolveInterceptorPredicateList(request, searchConfiguration.getAdditionalRestrictionResolverList(), criteriaBuilder, root, query);
        this.applyPredicatesToQuery(criteriaBuilder, query, searchConfiguration.isAnyMatch(), requestPredicateList, interceptorPredicateList);
    }

    private <P, R> List<Predicate> resolveQueryPredicateList(R request, SearchConfiguration<T, P, R> searchConfiguration, CriteriaBuilder criteriaBuilder, Root<?> root, CriteriaQuery<?> query) {
        Set<Restriction> restrictionList = new SearchDataParser((ManagedType<?>)root.getModel(), request, SearchDataParserConfiguration.fromSearchConfiguration(searchConfiguration)).resolveRestrictionList();
        Map<Boolean, List<Restriction>> restrictionsByType = restrictionList.stream().collect(Collectors.partitioningBy(Restriction::isPluralAttribute));
        List<Predicate> mainQueryPredicateList = this.convertRestrictionListToPredicateList((Collection<Restriction>)restrictionsByType.get(false), root, criteriaBuilder);
        List<Restriction> pluralRestrictionList = restrictionsByType.get(true);
        if (!CollectionUtils.isEmpty(pluralRestrictionList)) {
            if (searchConfiguration.getPluralAssociationRestrictionType() == PluralAssociationRestrictionType.JOIN) {
                mainQueryPredicateList.addAll(this.convertRestrictionListToPredicateList(pluralRestrictionList, root, criteriaBuilder));
            } else {
                SearchPropertyJoin searchPropertyJoin = this.resolveSearchPropertyJoin(root);
                Subquery<Integer> subquery2 = this.createSubqueryRestriction(root.getJavaType(), root, query, criteriaBuilder, pluralRestrictionList, searchPropertyJoin);
                mainQueryPredicateList.add(criteriaBuilder.exists(subquery2));
            }
        }
        List<Subquery<?>> subqueryList = this.resolveSubqueryList(request, searchConfiguration.getSearchPropertyConfiguration(), searchConfiguration.getSubqueryConfigurationList(), root, query, criteriaBuilder);
        subqueryList.forEach(subquery -> mainQueryPredicateList.add(criteriaBuilder.exists(subquery)));
        return mainQueryPredicateList;
    }

    private Subquery<Integer> createSubqueryRestriction(Class<?> subqueryEntityType, Root<?> parent, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder, Collection<Restriction> restrictionList, SearchPropertyJoin searchPropertyJoin) {
        Subquery subquery = query.subquery(Integer.class);
        Root subqueryRoot = subquery.from(subqueryEntityType);
        subquery.select(criteriaBuilder.literal((Object)1));
        List<Predicate> subQueryPredicateList = this.convertRestrictionListToPredicateList(restrictionList, subqueryRoot, criteriaBuilder);
        Path<?> parentPath = PathResolvingUtil.calculateFullRestrictionPath(parent, PathResolvingUtil.convertToPathList(searchPropertyJoin.getParentProperty()));
        Path<?> subqueryPath = PathResolvingUtil.calculateFullRestrictionPath(subqueryRoot, PathResolvingUtil.convertToPathList(searchPropertyJoin.getChildProperty()));
        subQueryPredicateList.add(criteriaBuilder.equal(parentPath, subqueryPath));
        return subquery.where(subQueryPredicateList.toArray(new Predicate[0]));
    }

    private List<Predicate> convertRestrictionListToPredicateList(Collection<Restriction> restrictionList, Root<?> rootPath, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        restrictionList.stream().filter(Objects::nonNull).forEach(restriction -> {
            String[] pathList = PathResolvingUtil.convertToPathList(restriction.getPath());
            if (restriction.isPluralAttribute()) {
                String[] pluralAttributePathList = Arrays.copyOfRange(pathList, 1, pathList.length);
                Path<?> fullPath = PathResolvingUtil.calculateFullRestrictionPath(rootPath.join(pathList[0]), pluralAttributePathList);
                predicateList.add(restriction.getSearchOperator().asPredicate(criteriaBuilder, fullPath, restriction.getValue()));
            } else {
                Path<?> fullPath = PathResolvingUtil.calculateFullRestrictionPath(rootPath, pathList);
                predicateList.add(restriction.getSearchOperator().asPredicate(criteriaBuilder, fullPath, restriction.getValue()));
            }
        });
        return predicateList;
    }

    private SearchPropertyJoin resolveSearchPropertyJoin(Root<?> root) {
        String idName = root.getModel().getId(root.getModel().getIdType().getJavaType()).getName();
        return new SearchPropertyJoin(idName, idName);
    }

    private <R> List<Subquery<?>> resolveSubqueryList(R request, SearchPropertyConfiguration searchPropertyConfiguration, List<SubqueryConfiguration> subqueryConfigurationList, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        if (CollectionUtils.isEmpty(subqueryConfigurationList)) {
            return Collections.emptyList();
        }
        return subqueryConfigurationList.stream().map(subqueryConfiguration -> this.buildSubquery(request, searchPropertyConfiguration, root, query, criteriaBuilder, (SubqueryConfiguration)subqueryConfiguration)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <R> Subquery<Integer> buildSubquery(R request, SearchPropertyConfiguration searchPropertyConfiguration, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder, SubqueryConfiguration subqueryConfiguration) {
        Set<Restriction> subqueryRestrictionList;
        ManagedType subqueryRoot = this.entityManager.getMetamodel().managedType(subqueryConfiguration.getRootEntity());
        if (subqueryConfiguration.getRestrictionPropertyHolder() == null) {
            String propertyPrefix = subqueryConfiguration.getPropertyPrefix() == null ? this.entityNamePrefix(subqueryConfiguration) : subqueryConfiguration.getPropertyPrefix();
            SearchDataParser searchDataParser = new SearchDataParser(subqueryRoot, request, this.searchDataParserConfiguration(searchPropertyConfiguration, false));
            subqueryRestrictionList = searchDataParser.resolveRestrictionList(propertyPrefix);
        } else {
            Object subqueryRestrictionPropertyHolder = new DirectFieldAccessFallbackBeanWrapper(request).getPropertyValue(subqueryConfiguration.getRestrictionPropertyHolder());
            SearchDataParser searchDataParser = new SearchDataParser(subqueryRoot, subqueryRestrictionPropertyHolder, this.searchDataParserConfiguration(searchPropertyConfiguration, true));
            subqueryRestrictionList = searchDataParser.resolveRestrictionList();
        }
        Subquery<Integer> subquery = null;
        if (!CollectionUtils.isEmpty(subqueryRestrictionList)) {
            subquery = this.createSubqueryRestriction(subqueryConfiguration.getRootEntity(), root, query, criteriaBuilder, subqueryRestrictionList, subqueryConfiguration.getJoinBy());
        }
        return subquery;
    }

    private <R> Selection<?> convertToSelectionExpression(Path<?> root, SearchProjection<R> projection) {
        String[] pathList = PathResolvingUtil.convertToPathList(projection.getPath());
        Path<?> path = PathResolvingUtil.calculateFullSelectionPath(root, pathList);
        String alias = projection.getAlias() == null ? pathList[pathList.length - 1] : projection.getAlias();
        return path.alias(alias);
    }

    private <R, P> List<Predicate> resolveInterceptorPredicateList(R request, List<AdditionalRestrictionResolver<T, P, R>> additionalRestrictionResolverList, CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<P> query) {
        return Optional.ofNullable(additionalRestrictionResolverList).orElse(Collections.emptyList()).stream().map(interceptor -> interceptor.resolvePredicateList(criteriaBuilder, query, root, request)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void applyPredicatesToQuery(CriteriaBuilder criteriaBuilder, CriteriaQuery<?> query, boolean anyMatch, List<Predicate> requestPredicateList, List<Predicate> interceptorPredicateList) {
        ArrayList<Predicate> fullPredicateList = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty(requestPredicateList)) {
            Predicate requestPredicate = anyMatch ? criteriaBuilder.or(requestPredicateList.toArray(new Predicate[0])) : criteriaBuilder.and(requestPredicateList.toArray(new Predicate[0]));
            fullPredicateList.add(requestPredicate);
        }
        if (!CollectionUtils.isEmpty(interceptorPredicateList)) {
            Predicate interceptorPredicate = criteriaBuilder.and(interceptorPredicateList.toArray(new Predicate[0]));
            fullPredicateList.add(interceptorPredicate);
        }
        if (!fullPredicateList.isEmpty()) {
            query.where(fullPredicateList.toArray(new Predicate[0]));
        }
    }

    private <R> boolean joinFetchExists(List<SearchJoin<R>> joinList) {
        return Optional.ofNullable(joinList).orElse(Collections.emptyList()).stream().anyMatch(SearchJoin::isFetch);
    }

    private String entityNamePrefix(SubqueryConfiguration subqueryConfiguration) {
        return StringUtils.uncapitalize((String)subqueryConfiguration.getRootEntity().getSimpleName());
    }

    private SearchDataParserConfiguration searchDataParserConfiguration(SearchPropertyConfiguration searchPropertyConfiguration, boolean resolvePropertyMappingUsingPrefix) {
        return SearchDataParserConfiguration.builder().searchPropertyConfiguration(searchPropertyConfiguration).resolvePropertyMappingUsingPrefix(resolvePropertyMappingUsingPrefix).build();
    }

    @ConstructorProperties(value={"entityManager", "entityType"})
    @Generated
    public JpaQueryBuilder(EntityManager entityManager, Class<T> entityType) {
        this.entityManager = entityManager;
        this.entityType = entityType;
    }
}

