/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.repository;

import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import net.croz.nrich.search.api.repository.NaturalIdSearchExecutor;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class HibernateNaturalIdSearchExecutor<T>
implements NaturalIdSearchExecutor<T> {
    private final EntityManager entityManager;
    private final Class<T> javaType;

    public HibernateNaturalIdSearchExecutor(EntityManager entityManager, Class<T> javaType) {
        this.entityManager = entityManager;
        this.javaType = javaType;
    }

    public <I extends Serializable> Optional<T> findBySimpleNaturalId(I naturalId) {
        return this.resolveSession().bySimpleNaturalId(this.javaType).loadOptional(naturalId);
    }

    public Optional<T> findByNaturalId(Map<String, Object> naturalId) {
        NaturalIdLoadAccess naturalIdLoadAccess = this.resolveSession().byNaturalId(this.javaType);
        naturalId.forEach((arg_0, arg_1) -> ((NaturalIdLoadAccess)naturalIdLoadAccess).using(arg_0, arg_1));
        return naturalIdLoadAccess.loadOptional();
    }

    private Session resolveSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }
}

