/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.support;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.ManagedType;
import lombok.Generated;
import net.croz.nrich.search.api.model.AdditionalRestrictionResolver;
import net.croz.nrich.search.api.model.PluralAssociationRestrictionType;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.model.SearchJoin;
import net.croz.nrich.search.api.model.SearchProjection;
import net.croz.nrich.search.api.model.property.SearchPropertyConfiguration;
import net.croz.nrich.search.api.model.property.SearchPropertyJoin;
import net.croz.nrich.search.api.model.subquery.SubqueryConfiguration;
import net.croz.nrich.search.model.Restriction;
import net.croz.nrich.search.model.SearchDataParserConfiguration;
import net.croz.nrich.search.parser.SearchDataParser;
import net.croz.nrich.search.util.PathResolvingUtil;
import net.croz.nrich.search.util.ProjectionListResolverUtil;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JpaQueryBuilder<T> {
    private final EntityManager entityManager;
    private final Class<T> entityType;

    public <R, P> CriteriaQuery<P> buildQuery(R request, SearchConfiguration<T, P, R> searchConfiguration, Sort sort) {
        List<Selection<?>> projectionList;
        Assert.notNull(request, (String)"Search request is not defined!");
        Assert.notNull(searchConfiguration, (String)"Search configuration is not defined!");
        Assert.notNull((Object)sort, (String)"Sort is not defined!");
        Class rootEntity = searchConfiguration.getRootEntityResolver() == null ? this.entityType : (Class)searchConfiguration.getRootEntityResolver().apply(request);
        Assert.notNull((Object)rootEntity, (String)"Root entity returned by resolver is not defined!");
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<P> resultClass = this.resolveResultClass(searchConfiguration, rootEntity);
        Assert.isTrue((!this.joinFetchExists(searchConfiguration.getJoinList()) || this.entityType.isAssignableFrom(resultClass) ? 1 : 0) != 0, (String)"Join Fetch is ony possible when result class is not an projection!");
        CriteriaQuery query = criteriaBuilder.createQuery(resultClass);
        Root root = query.from(rootEntity);
        this.applyJoinsOrFetchesToQuery(request, root, searchConfiguration.getJoinList());
        List searchProjectionList = searchConfiguration.getProjectionList();
        if (!resultClass.equals(this.entityType) && CollectionUtils.isEmpty((Collection)searchProjectionList)) {
            searchProjectionList = ProjectionListResolverUtil.resolveSearchProjectionList(resultClass);
        }
        if (!CollectionUtils.isEmpty(projectionList = this.resolveQueryProjectionList(root, searchProjectionList, request))) {
            query.multiselect(projectionList);
        }
        query.distinct(searchConfiguration.isDistinct());
        List<Predicate> requestPredicateList = this.resolveQueryPredicateList(request, searchConfiguration, criteriaBuilder, root, query);
        List<Predicate> interceptorPredicateList = this.resolveInterceptorPredicateList(request, searchConfiguration.getAdditionalRestrictionResolverList(), criteriaBuilder, root, query);
        this.applyPredicatesToQuery(criteriaBuilder, query, searchConfiguration.isAnyMatch(), requestPredicateList, interceptorPredicateList);
        if (sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder));
        }
        return query;
    }

    public CriteriaQuery<Long> convertToCountQuery(CriteriaQuery<?> query) {
        CriteriaQuery<?> countQuery = query;
        this.clearSortAndFetchesFromQuery(countQuery);
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        Root root = (Root)query.getRoots().iterator().next();
        if (countQuery.isDistinct()) {
            countQuery.select((Selection)builder.countDistinct((Expression)root));
        } else {
            countQuery.select((Selection)builder.count((Expression)root));
        }
        return countQuery;
    }

    public CriteriaQuery<Integer> convertToExistsQuery(CriteriaQuery<?> query) {
        CriteriaQuery<?> existsQuery = query;
        this.clearSortAndFetchesFromQuery(existsQuery);
        existsQuery.select((Selection)this.entityManager.getCriteriaBuilder().literal((Object)1));
        return existsQuery;
    }

    private <R, P> Class<P> resolveResultClass(SearchConfiguration<T, P, R> searchConfiguration, Class<T> rootEntity) {
        return searchConfiguration.getResultClass() == null ? rootEntity : searchConfiguration.getResultClass();
    }

    private <R> void applyJoinsOrFetchesToQuery(R request, Root<?> root, List<SearchJoin<R>> joinList) {
        if (CollectionUtils.isEmpty(joinList)) {
            return;
        }
        joinList.stream().filter(join -> this.shouldApplyJoinOrFetch((SearchJoin)join, request)).forEach(searchJoin -> this.applyJoinOrJoinFetch(root, (SearchJoin<?>)searchJoin));
    }

    private <R> List<Selection<?>> resolveQueryProjectionList(Root<?> root, List<SearchProjection<R>> projectionList, R request) {
        if (CollectionUtils.isEmpty(projectionList)) {
            return Collections.emptyList();
        }
        return projectionList.stream().filter(projection -> this.shouldApplyProjection((SearchProjection)projection, request)).map(projection -> this.convertToSelectionExpression((Path<?>)root, (SearchProjection)projection)).collect(Collectors.toList());
    }

    private <R> boolean shouldApplyJoinOrFetch(SearchJoin<R> join, R request) {
        return join.getCondition() == null || join.getCondition().test(request);
    }

    private void applyJoinOrJoinFetch(Root<?> root, SearchJoin<?> searchJoin) {
        JoinType joinType = searchJoin.getJoinType() == null ? JoinType.INNER : searchJoin.getJoinType();
        String[] pathList = PathResolvingUtil.convertToPathList(searchJoin.getPath());
        if (searchJoin.isFetch()) {
            Fetch fetch = null;
            for (String path : pathList) {
                fetch = fetch == null ? root.fetch(path, joinType) : fetch.fetch(path, joinType);
            }
        } else {
            Join join = null;
            for (String path : pathList) {
                join = join == null ? root.join(path, joinType) : join.join(path, joinType);
            }
            if (searchJoin.getAlias().indexOf(46) == -1) {
                ((Join)Objects.requireNonNull(join)).alias(searchJoin.getAlias());
            }
        }
    }

    private <R> boolean shouldApplyProjection(SearchProjection<R> projection, R request) {
        return projection.getCondition() == null || projection.getCondition().test(request);
    }

    private <P, R> List<Predicate> resolveQueryPredicateList(R request, SearchConfiguration<T, P, R> searchConfiguration, CriteriaBuilder criteriaBuilder, Root<?> root, CriteriaQuery<?> query) {
        Set<Restriction> restrictionList = new SearchDataParser((ManagedType<?>)root.getModel(), request, SearchDataParserConfiguration.fromSearchConfiguration(searchConfiguration)).resolveRestrictionList();
        Map<Boolean, List<Restriction>> restrictionsByType = restrictionList.stream().collect(Collectors.partitioningBy(Restriction::isPluralAttribute));
        List<Predicate> mainQueryPredicateList = this.convertRestrictionListToPredicateList((Collection<Restriction>)restrictionsByType.get(false), root, criteriaBuilder);
        List<Restriction> pluralRestrictionList = restrictionsByType.get(true);
        if (!CollectionUtils.isEmpty(pluralRestrictionList)) {
            if (searchConfiguration.getPluralAssociationRestrictionType() == PluralAssociationRestrictionType.JOIN) {
                mainQueryPredicateList.addAll(this.convertRestrictionListToPredicateList(pluralRestrictionList, root, criteriaBuilder));
            } else {
                Subquery<Integer> subquery2 = this.createSubqueryRestriction(root.getJavaType(), root, query, criteriaBuilder, pluralRestrictionList, SearchPropertyJoin.defaultJoinById());
                mainQueryPredicateList.add(criteriaBuilder.exists(subquery2));
            }
        }
        List<Subquery<?>> subqueryList = this.resolveSubqueryList(request, searchConfiguration.getSearchPropertyConfiguration(), searchConfiguration.getSubqueryConfigurationList(), root, query, criteriaBuilder);
        subqueryList.forEach(subquery -> mainQueryPredicateList.add(criteriaBuilder.exists(subquery)));
        return mainQueryPredicateList;
    }

    private Subquery<Integer> createSubqueryRestriction(Class<?> subqueryEntityType, Root<?> parent, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder, Collection<Restriction> restrictionList, SearchPropertyJoin searchPropertyJoin) {
        Subquery subquery = query.subquery(Integer.class);
        Root subqueryRoot = subquery.from(subqueryEntityType);
        subquery.select(criteriaBuilder.literal((Object)1));
        List<Predicate> subQueryPredicateList = this.convertRestrictionListToPredicateList(restrictionList, subqueryRoot, criteriaBuilder);
        Path<?> parentPath = PathResolvingUtil.calculateFullPath(parent, PathResolvingUtil.convertToPathList(searchPropertyJoin.getParentProperty()));
        Path<?> subqueryPath = PathResolvingUtil.calculateFullPath(subqueryRoot, PathResolvingUtil.convertToPathList(searchPropertyJoin.getChildProperty()));
        subQueryPredicateList.add(criteriaBuilder.equal(parentPath, subqueryPath));
        return subquery.where(subQueryPredicateList.toArray(new Predicate[0]));
    }

    private List<Predicate> convertRestrictionListToPredicateList(Collection<Restriction> restrictionList, Root<?> rootPath, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        restrictionList.stream().filter(Objects::nonNull).forEach(restriction -> {
            String[] pathList = PathResolvingUtil.convertToPathList(restriction.getPath());
            if (restriction.isPluralAttribute()) {
                String[] pluralAttributePathList = Arrays.copyOfRange(pathList, 1, pathList.length);
                Path<?> fullPath = PathResolvingUtil.calculateFullPath(rootPath.join(pathList[0]), pluralAttributePathList);
                predicateList.add(restriction.getSearchOperator().asPredicate(criteriaBuilder, fullPath, restriction.getValue()));
            } else {
                Path<?> fullPath = PathResolvingUtil.calculateFullPath(rootPath, pathList);
                predicateList.add(restriction.getSearchOperator().asPredicate(criteriaBuilder, fullPath, restriction.getValue()));
            }
        });
        return predicateList;
    }

    private <R> List<Subquery<?>> resolveSubqueryList(R request, SearchPropertyConfiguration searchPropertyConfiguration, List<SubqueryConfiguration> subqueryConfigurationList, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        if (CollectionUtils.isEmpty(subqueryConfigurationList)) {
            return Collections.emptyList();
        }
        return subqueryConfigurationList.stream().map(subqueryConfiguration -> this.buildSubquery(request, searchPropertyConfiguration, root, query, criteriaBuilder, (SubqueryConfiguration)subqueryConfiguration)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <R> Subquery<Integer> buildSubquery(R request, SearchPropertyConfiguration searchPropertyConfiguration, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder, SubqueryConfiguration subqueryConfiguration) {
        Set<Restriction> subqueryRestrictionList;
        ManagedType subqueryRoot = this.entityManager.getMetamodel().managedType(subqueryConfiguration.getRootEntity());
        if (subqueryConfiguration.getRestrictionPropertyHolder() == null) {
            String propertyPrefix = subqueryConfiguration.getPropertyPrefix() == null ? this.entityNamePrefix(subqueryConfiguration) : subqueryConfiguration.getPropertyPrefix();
            SearchDataParser searchDataParser = new SearchDataParser(subqueryRoot, request, this.searchDataParserConfiguration(searchPropertyConfiguration, false));
            subqueryRestrictionList = searchDataParser.resolveRestrictionList(propertyPrefix);
        } else {
            Object subqueryRestrictionPropertyHolder = new DirectFieldAccessFallbackBeanWrapper(request).getPropertyValue(subqueryConfiguration.getRestrictionPropertyHolder());
            SearchDataParser searchDataParser = new SearchDataParser(subqueryRoot, subqueryRestrictionPropertyHolder, this.searchDataParserConfiguration(searchPropertyConfiguration, true));
            subqueryRestrictionList = searchDataParser.resolveRestrictionList();
        }
        Subquery<Integer> subquery = null;
        if (!CollectionUtils.isEmpty(subqueryRestrictionList)) {
            subquery = this.createSubqueryRestriction(subqueryConfiguration.getRootEntity(), root, query, criteriaBuilder, subqueryRestrictionList, subqueryConfiguration.getJoinBy());
        }
        return subquery;
    }

    private <R> Selection<?> convertToSelectionExpression(Path<?> root, SearchProjection<R> projection) {
        String[] pathList = PathResolvingUtil.convertToPathList(projection.getPath());
        Path<?> path = PathResolvingUtil.calculateFullPath(root, pathList);
        String alias = projection.getAlias() == null ? pathList[pathList.length - 1] : projection.getAlias();
        return path.alias(alias);
    }

    private <R, P> List<Predicate> resolveInterceptorPredicateList(R request, List<AdditionalRestrictionResolver<T, P, R>> additionalRestrictionResolverList, CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<P> query) {
        return Optional.ofNullable(additionalRestrictionResolverList).orElse(Collections.emptyList()).stream().map(interceptor -> interceptor.resolvePredicateList(criteriaBuilder, query, root, request)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void applyPredicatesToQuery(CriteriaBuilder criteriaBuilder, CriteriaQuery<?> query, boolean anyMatch, List<Predicate> requestPredicateList, List<Predicate> interceptorPredicateList) {
        ArrayList<Predicate> fullPredicateList = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty(requestPredicateList)) {
            Predicate requestPredicate = anyMatch ? criteriaBuilder.or(requestPredicateList.toArray(new Predicate[0])) : criteriaBuilder.and(requestPredicateList.toArray(new Predicate[0]));
            fullPredicateList.add(requestPredicate);
        }
        if (!CollectionUtils.isEmpty(interceptorPredicateList)) {
            Predicate interceptorPredicate = criteriaBuilder.and(interceptorPredicateList.toArray(new Predicate[0]));
            fullPredicateList.add(interceptorPredicate);
        }
        query.where(fullPredicateList.toArray(new Predicate[0]));
    }

    private <R> boolean joinFetchExists(List<SearchJoin<R>> joinList) {
        return Optional.ofNullable(joinList).orElse(Collections.emptyList()).stream().anyMatch(SearchJoin::isFetch);
    }

    private String entityNamePrefix(SubqueryConfiguration subqueryConfiguration) {
        return StringUtils.uncapitalize((String)subqueryConfiguration.getRootEntity().getSimpleName());
    }

    private SearchDataParserConfiguration searchDataParserConfiguration(SearchPropertyConfiguration searchPropertyConfiguration, boolean resolvePropertyMappingUsingPrefix) {
        return SearchDataParserConfiguration.builder().searchPropertyConfiguration(searchPropertyConfiguration).resolvePropertyMappingUsingPrefix(resolvePropertyMappingUsingPrefix).build();
    }

    private void clearSortAndFetchesFromQuery(CriteriaQuery<?> query) {
        query.orderBy(Collections.emptyList());
        query.getRoots().forEach(root -> root.getFetches().clear());
    }

    @ConstructorProperties(value={"entityManager", "entityType"})
    @Generated
    public JpaQueryBuilder(EntityManager entityManager, Class<T> entityType) {
        this.entityManager = entityManager;
        this.entityType = entityType;
    }
}

