/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import net.croz.nrich.search.api.converter.StringToEntityPropertyMapConverter;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.repository.StringSearchExecutor;
import net.croz.nrich.search.support.JpaQueryBuilder;
import net.croz.nrich.search.util.QueryUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaStringSearchExecutor<T>
implements StringSearchExecutor<T> {
    private final StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter;
    private final EntityManager entityManager;
    private final JpaEntityInformation<T, ?> jpaEntityInformation;
    private final JpaQueryBuilder<T> queryBuilder;

    public JpaStringSearchExecutor(StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter, EntityManager entityManager, JpaEntityInformation<T, ?> jpaEntityInformation) {
        this.stringToEntityPropertyMapConverter = stringToEntityPropertyMapConverter;
        this.entityManager = entityManager;
        this.jpaEntityInformation = jpaEntityInformation;
        this.queryBuilder = new JpaQueryBuilder(entityManager, jpaEntityInformation.getJavaType());
    }

    public <P> Optional<P> findOne(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted());
        try {
            return Optional.of(this.entityManager.createQuery(query).getSingleResult());
        }
        catch (NoResultException ignored) {
            return Optional.empty();
        }
    }

    public <P> List<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted());
        return this.entityManager.createQuery(query).getResultList();
    }

    public <P> List<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration, Sort sort) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, sort);
        return this.entityManager.createQuery(query).getResultList();
    }

    public <P> Page<P> findAll(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration, Pageable pageable) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        CriteriaQuery query = this.queryBuilder.buildQuery(searchMap, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        if (pageable.isPaged()) {
            typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
            return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(query));
        }
        return new PageImpl(typedQuery.getResultList());
    }

    public <P> long count(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        return this.executeCountQuery(this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted()));
    }

    public <P> boolean exists(String searchTerm, List<String> propertyToSearchList, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        Map<String, Object> searchMap = this.convertToMap(searchTerm, propertyToSearchList);
        return this.executeCountQuery(this.queryBuilder.buildQuery(searchMap, searchConfiguration, Sort.unsorted())) > 0L;
    }

    private Map<String, Object> convertToMap(String searchTerm, List<String> propertyToSearchList) {
        return this.stringToEntityPropertyMapConverter.convert(searchTerm, propertyToSearchList, this.jpaEntityInformation.getRequiredIdAttribute().getDeclaringType());
    }

    private long executeCountQuery(CriteriaQuery<?> query) {
        CriteriaQuery<Long> countQuery = this.queryBuilder.convertToCountQuery(query);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return QueryUtil.toCountResult(totals);
    }
}

