/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.repository;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.repository.SearchExecutor;
import net.croz.nrich.search.support.JpaQueryBuilder;
import net.croz.nrich.search.util.QueryUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaSearchExecutor<T>
implements SearchExecutor<T> {
    private final EntityManager entityManager;
    private final JpaQueryBuilder<T> queryBuilder;

    public JpaSearchExecutor(EntityManager entityManager, JpaEntityInformation<T, ?> entityInformation) {
        this.entityManager = entityManager;
        this.queryBuilder = new JpaQueryBuilder(entityManager, entityInformation.getJavaType());
    }

    public <R, P> Optional<P> findOne(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted());
        try {
            return Optional.of(this.entityManager.createQuery(query).getSingleResult());
        }
        catch (NoResultException ignored) {
            return Optional.empty();
        }
    }

    public <R, P> List<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted());
        return this.entityManager.createQuery(query).getResultList();
    }

    public <R, P> List<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration, Sort sort) {
        CriteriaQuery<P> query = this.queryBuilder.buildQuery(request, searchConfiguration, sort);
        return this.entityManager.createQuery(query).getResultList();
    }

    public <R, P> Page<P> findAll(R request, SearchConfiguration<T, P, R> searchConfiguration, Pageable pageable) {
        CriteriaQuery query = this.queryBuilder.buildQuery(request, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        if (pageable.isPaged()) {
            typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
            return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(query));
        }
        return new PageImpl(typedQuery.getResultList());
    }

    public <R, P> long count(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        return this.executeCountQuery(this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted()));
    }

    public <R, P> boolean exists(R request, SearchConfiguration<T, P, R> searchConfiguration) {
        return this.executeCountQuery(this.queryBuilder.buildQuery(request, searchConfiguration, Sort.unsorted())) > 0L;
    }

    private long executeCountQuery(CriteriaQuery<?> query) {
        CriteriaQuery<Long> countQuery = this.queryBuilder.convertToCountQuery(query);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return QueryUtil.toCountResult(totals);
    }
}

