/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.converter;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.Generated;
import net.croz.nrich.search.api.converter.StringToTypeConverter;
import org.springframework.core.annotation.Order;

@Order
public class DefaultStringToTypeConverter
implements StringToTypeConverter<Object> {
    private final List<String> dateFormatList;
    private final List<String> decimalNumberFormatList;
    private final String booleanTrueRegexPattern;
    private final String booleanFalseRegexPattern;
    private final List<ConverterHolder> converterHolderList;

    public DefaultStringToTypeConverter(List<String> dateFormatList, List<String> decimalNumberFormatList, String booleanTrueRegexPattern, String booleanFalseRegexPattern) {
        this.dateFormatList = dateFormatList;
        this.decimalNumberFormatList = decimalNumberFormatList;
        this.booleanTrueRegexPattern = booleanTrueRegexPattern;
        this.booleanFalseRegexPattern = booleanFalseRegexPattern;
        this.converterHolderList = this.initializeConverterList();
    }

    public Object convert(String value, Class<?> requiredType) {
        if (value == null) {
            return null;
        }
        ConverterHolder converterHolder = this.converterHolderList.stream().filter(holder -> holder.getType().isAssignableFrom(requiredType)).findFirst().orElse(null);
        Object convertedValue = null;
        if (converterHolder != null) {
            convertedValue = this.convertWithExceptionIgnored(() -> converterHolder.getConversionFunction().apply(value, requiredType));
        }
        return convertedValue;
    }

    public boolean supports(Class<?> requiredType) {
        return true;
    }

    private Object convertWithExceptionIgnored(Supplier<Object> conversionFunction) {
        try {
            return conversionFunction.get();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private List<ConverterHolder> initializeConverterList() {
        return Arrays.asList(new ConverterHolder(Boolean.class, (value, type) -> this.booleanConverter((String)value)), new ConverterHolder(Long.class, (value, type) -> Long.valueOf(value)), new ConverterHolder(Integer.class, (value, type) -> Integer.valueOf(value)), new ConverterHolder(Short.class, (value, type) -> Short.valueOf(value)), new ConverterHolder(Enum.class, this::enumConverter), new ConverterHolder(Date.class, (value, type) -> this.dateConverter((String)value)), new ConverterHolder(Instant.class, (value, type) -> this.temporalConverter((String)value, Instant::from)), new ConverterHolder(LocalDate.class, (value, type) -> this.temporalConverter((String)value, LocalDate::from)), new ConverterHolder(LocalDateTime.class, (value, type) -> this.temporalConverter((String)value, LocalDateTime::from)), new ConverterHolder(OffsetTime.class, (value, type) -> this.temporalConverter((String)value, OffsetTime::from)), new ConverterHolder(OffsetDateTime.class, (value, type) -> this.temporalConverter((String)value, OffsetDateTime::from)), new ConverterHolder(ZonedDateTime.class, (value, type) -> this.temporalConverter((String)value, ZonedDateTime::from)), new ConverterHolder(Float.class, (value, type) -> this.numberConverter((String)value, false)), new ConverterHolder(Double.class, (value, type) -> this.numberConverter((String)value, false)), new ConverterHolder(BigDecimal.class, (value, type) -> this.numberConverter((String)value, true)));
    }

    private Boolean booleanConverter(String value) {
        Boolean convertedValue = null;
        if (value.matches(this.booleanTrueRegexPattern)) {
            convertedValue = Boolean.TRUE;
        } else if (value.matches(this.booleanFalseRegexPattern)) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }

    private <E extends Enum<E>> E enumConverter(String value, Class<?> requiredType) {
        Class<?> enumType = requiredType;
        return (E)Enum.valueOf(enumType, value);
    }

    private Object dateConverter(String value) {
        return this.dateFormatList.stream().map(SimpleDateFormat::new).map(format -> this.convertWithExceptionIgnored(() -> this.parseDate((SimpleDateFormat)format, value))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Object temporalConverter(String value, TemporalQuery<?> query) {
        return this.dateFormatList.stream().map(DateTimeFormatter::ofPattern).map(format -> this.convertWithExceptionIgnored(() -> format.parse((CharSequence)value, query))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Object numberConverter(String value, boolean parseBigDecimal) {
        return this.decimalNumberFormatList.stream().map(format -> {
            DecimalFormat decimalFormat = new DecimalFormat((String)format);
            decimalFormat.setParseBigDecimal(parseBigDecimal);
            return decimalFormat;
        }).map(format -> this.convertWithExceptionIgnored(() -> this.parseNumber((DecimalFormat)format, value))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Object parseDate(SimpleDateFormat format, String value) {
        return format.parse(value);
    }

    private Object parseNumber(DecimalFormat format, String value) {
        return format.parse(value);
    }

    public static class ConverterHolder {
        private final Class<?> type;
        private final BiFunction<String, Class<?>, Object> conversionFunction;

        @ConstructorProperties(value={"type", "conversionFunction"})
        @Generated
        public ConverterHolder(Class<?> type, BiFunction<String, Class<?>, Object> conversionFunction) {
            this.type = type;
            this.conversionFunction = conversionFunction;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public BiFunction<String, Class<?>, Object> getConversionFunction() {
            return this.conversionFunction;
        }
    }
}

