/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.parser;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import lombok.Generated;
import net.croz.nrich.search.api.model.operator.DefaultSearchOperator;
import net.croz.nrich.search.api.model.operator.SearchOperator;
import net.croz.nrich.search.api.model.operator.SearchOperatorOverride;
import net.croz.nrich.search.api.model.property.SearchPropertyConfiguration;
import net.croz.nrich.search.api.model.property.SearchPropertyMapping;
import net.croz.nrich.search.bean.MapSupportingDirectFieldAccessFallbackBeanWrapper;
import net.croz.nrich.search.model.AttributeHolder;
import net.croz.nrich.search.model.Restriction;
import net.croz.nrich.search.model.SearchDataParserConfiguration;
import net.croz.nrich.search.support.JpaEntityAttributeResolver;
import org.springframework.util.StringUtils;

public class SearchDataParser {
    private final ManagedType<?> managedType;
    private final Object searchData;
    private final SearchDataParserConfiguration searchConfiguration;

    public Set<Restriction> resolveRestrictionList() {
        return this.resolveRestrictionList(null);
    }

    public Set<Restriction> resolveRestrictionList(String propertyPrefix) {
        return this.resolveRestrictionListInternal(new MapSupportingDirectFieldAccessFallbackBeanWrapper(this.searchData), propertyPrefix, null, this.managedType, new HashSet<Restriction>(), false);
    }

    private Set<Restriction> resolveRestrictionListInternal(MapSupportingDirectFieldAccessFallbackBeanWrapper wrapper, String propertyPrefix, String path, ManagedType<?> managedType, Set<Restriction> restrictionList, boolean isPluralAttribute) {
        List<String> fieldNameList = this.resolveFieldNameList(wrapper);
        JpaEntityAttributeResolver attributeResolver = new JpaEntityAttributeResolver(managedType);
        fieldNameList.forEach(originalFieldName -> {
            String fieldNameWithoutPrefixAndSuffix = this.fieldNameWithoutSuffixAndPrefix((String)originalFieldName, propertyPrefix);
            Object value = wrapper.getPropertyValue((String)originalFieldName);
            if (value == null) {
                return;
            }
            AttributeHolder attributeHolder = attributeResolver.resolveAttributeByPath(fieldNameWithoutPrefixAndSuffix);
            if (attributeHolder.getAttribute() != null) {
                String currentPath;
                String string = currentPath = path == null ? fieldNameWithoutPrefixAndSuffix : path + "." + fieldNameWithoutPrefixAndSuffix;
                if (attributeHolder.getManagedType() != null) {
                    this.resolveRestrictionListInternal(new MapSupportingDirectFieldAccessFallbackBeanWrapper(value), propertyPrefix, currentPath, attributeHolder.getManagedType(), restrictionList, attributeHolder.isPlural());
                    return;
                }
                restrictionList.add(this.createAttributeRestriction(attributeHolder.getAttribute().getJavaType(), (String)originalFieldName, currentPath, value, isPluralAttribute));
            } else if (this.searchUsingPropertyMapping(this.searchConfiguration)) {
                String mappedPath = this.findPathUsingMapping(this.searchConfiguration.getPropertyMappingList(), (String)originalFieldName);
                if (mappedPath == null) {
                    mappedPath = this.findPathUsingAttributePrefix((String)originalFieldName, managedType);
                }
                if (mappedPath != null && (attributeHolder = attributeResolver.resolveAttributeByPath(mappedPath)).getAttribute() != null) {
                    restrictionList.add(this.createAttributeRestriction(attributeHolder.getAttribute().getJavaType(), (String)originalFieldName, mappedPath, value, attributeHolder.isPlural()));
                }
            }
        });
        return restrictionList;
    }

    private List<String> resolveFieldNameList(MapSupportingDirectFieldAccessFallbackBeanWrapper wrapper) {
        List ignoredFieldList;
        List list = ignoredFieldList = this.searchConfiguration.getSearchPropertyConfiguration().getSearchIgnoredPropertyList() == null ? Collections.emptyList() : this.searchConfiguration.getSearchPropertyConfiguration().getSearchIgnoredPropertyList();
        if (wrapper.getEntityAsMap() != null) {
            return wrapper.getEntityAsMap().keySet().stream().filter(key -> !ignoredFieldList.contains(key)).collect(Collectors.toList());
        }
        Predicate<Field> shouldIncludeField = field -> !ignoredFieldList.contains(field.getName()) && !field.isSynthetic() && !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
        return Arrays.stream(wrapper.getRootClass().getDeclaredFields()).filter(shouldIncludeField).map(Field::getName).collect(Collectors.toList());
    }

    private String fieldNameWithoutSuffixAndPrefix(String originalFieldName, String prefix) {
        SearchPropertyConfiguration searchPropertyConfiguration = this.searchConfiguration.getSearchPropertyConfiguration();
        String[] suffixListToRemove = new String[]{searchPropertyConfiguration.getRangeQueryFromIncludingSuffix(), searchPropertyConfiguration.getRangeQueryFromSuffix(), searchPropertyConfiguration.getRangeQueryToIncludingSuffix(), searchPropertyConfiguration.getRangeQueryToSuffix(), searchPropertyConfiguration.getCollectionQuerySuffix()};
        String fieldName = originalFieldName;
        for (String suffix : suffixListToRemove) {
            if (!originalFieldName.endsWith(suffix)) continue;
            fieldName = originalFieldName.substring(0, originalFieldName.lastIndexOf(suffix));
            break;
        }
        if (prefix != null && fieldName.length() > prefix.length()) {
            return StringUtils.uncapitalize((String)fieldName.substring(prefix.length()));
        }
        return fieldName;
    }

    private Restriction createAttributeRestriction(Class<?> attributeType, String attributeName, String path, Object value, boolean isPluralAttribute) {
        boolean isRangeSearchSupported = this.isRangeSearchSupported(attributeType);
        SearchOperator resolvedOperator = this.resolveFromSearchConfiguration(this.searchConfiguration, path, attributeType);
        SearchPropertyConfiguration searchPropertyConfiguration = this.searchConfiguration.getSearchPropertyConfiguration();
        DefaultSearchOperator operator = DefaultSearchOperator.EQ;
        if (resolvedOperator != null) {
            operator = resolvedOperator;
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            operator = DefaultSearchOperator.IN;
        } else if (String.class.isAssignableFrom(attributeType)) {
            operator = DefaultSearchOperator.ILIKE;
        } else if (isRangeSearchSupported) {
            if (attributeName.endsWith(searchPropertyConfiguration.getRangeQueryFromIncludingSuffix())) {
                operator = DefaultSearchOperator.GE;
            } else if (attributeName.endsWith(searchPropertyConfiguration.getRangeQueryFromSuffix())) {
                operator = DefaultSearchOperator.GT;
            } else if (attributeName.endsWith(searchPropertyConfiguration.getRangeQueryToIncludingSuffix())) {
                operator = DefaultSearchOperator.LE;
            } else if (attributeName.endsWith(searchPropertyConfiguration.getRangeQueryToSuffix())) {
                operator = DefaultSearchOperator.LT;
            }
        }
        return new Restriction(path, (SearchOperator)operator, value, isPluralAttribute);
    }

    private boolean isRangeSearchSupported(Class<?> attributeType) {
        return this.searchConfiguration.getSearchPropertyConfiguration().getRangeQuerySupportedClassList() != null && this.searchConfiguration.getSearchPropertyConfiguration().getRangeQuerySupportedClassList().stream().anyMatch(type -> type.isAssignableFrom(attributeType));
    }

    private String findPathUsingMapping(List<SearchPropertyMapping> propertyMappingList, String fieldName) {
        return Optional.ofNullable(propertyMappingList).orElse(Collections.emptyList()).stream().filter(mapping -> fieldName.equals(mapping.getName())).map(SearchPropertyMapping::getPath).findAny().orElse(null);
    }

    private String findPathUsingAttributePrefix(String originalFieldName, ManagedType<?> managedType) {
        List attributeNameList = managedType.getAttributes().stream().filter(attribute -> attribute.isAssociation() || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED).map(Attribute::getName).collect(Collectors.toList());
        return attributeNameList.stream().filter(attribute -> this.isFieldNameValid(originalFieldName, (String)attribute)).map(attribute -> attribute + "." + StringUtils.uncapitalize((String)originalFieldName.substring(attribute.length()))).findFirst().orElse(null);
    }

    private boolean searchUsingPropertyMapping(SearchDataParserConfiguration searchConfiguration) {
        return searchConfiguration.isResolvePropertyMappingUsingPrefix() || searchConfiguration.getPropertyMappingList() != null;
    }

    private SearchOperator resolveFromSearchConfiguration(SearchDataParserConfiguration searchConfiguration, String path, Class<?> attributeType) {
        SearchOperator operator = null;
        SearchOperatorOverride operatorOverride = this.findOperatorOverride(searchConfiguration.getSearchOperatorOverrideList(), value -> path.equals(value.getPropertyPath()));
        if (operatorOverride == null) {
            operatorOverride = this.findOperatorOverride(searchConfiguration.getSearchOperatorOverrideList(), value -> value.getPropertyType() != null && attributeType.isAssignableFrom(value.getPropertyType()));
        }
        if (operatorOverride != null) {
            operator = operatorOverride.getSearchOperator();
        }
        return operator;
    }

    private SearchOperatorOverride findOperatorOverride(List<SearchOperatorOverride> searchOperatorOverrideList, Predicate<SearchOperatorOverride> searchOperatorOverridePredicate) {
        return Optional.ofNullable(searchOperatorOverrideList).orElse(Collections.emptyList()).stream().filter(searchOperatorOverridePredicate).findFirst().orElse(null);
    }

    private boolean isFieldNameValid(String fieldName, String attribute) {
        return fieldName.startsWith(attribute) && fieldName.length() > attribute.length();
    }

    @ConstructorProperties(value={"managedType", "searchData", "searchConfiguration"})
    @Generated
    public SearchDataParser(ManagedType<?> managedType, Object searchData, SearchDataParserConfiguration searchConfiguration) {
        this.managedType = managedType;
        this.searchData = searchData;
        this.searchConfiguration = searchConfiguration;
    }
}

