/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.support;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import lombok.Generated;
import net.croz.nrich.search.model.AttributeHolder;
import net.croz.nrich.search.util.PathResolvingUtil;
import org.springframework.util.Assert;

public class JpaEntityAttributeResolver {
    private final ManagedType<?> managedType;

    public AttributeHolder resolveAttributeByPath(String path) {
        Assert.notNull((Object)path, (String)"Path must be defined when searching for attribute!");
        String[] pathList = PathResolvingUtil.convertToPathList(path);
        Attribute<?, ?> attribute = this.resolveAttributeByName(this.managedType, pathList[0]);
        boolean isPlural = attribute instanceof PluralAttribute;
        ManagedType<?> managedType = this.resolveManagedTypeFromAttribute(attribute);
        if (managedType != null && pathList.length > 1) {
            String[] restOfPathList;
            for (String currentPath : restOfPathList = Arrays.copyOfRange(pathList, 1, pathList.length)) {
                if (managedType == null) {
                    attribute = null;
                    isPlural = false;
                    break;
                }
                attribute = this.resolveAttributeByName(managedType, currentPath);
                managedType = this.resolveManagedTypeFromAttribute(attribute);
                isPlural |= attribute instanceof PluralAttribute;
            }
        }
        return new AttributeHolder(attribute, managedType, isPlural);
    }

    private ManagedType<?> resolveManagedTypeFromAttribute(Attribute<?, ?> attribute) {
        ManagedType managedType = null;
        if (attribute instanceof SingularAttribute && ((SingularAttribute)attribute).getType() instanceof ManagedType) {
            managedType = (ManagedType)((SingularAttribute)attribute).getType();
        } else if (attribute instanceof PluralAttribute && ((PluralAttribute)attribute).getElementType() instanceof ManagedType) {
            managedType = (ManagedType)((PluralAttribute)attribute).getElementType();
        }
        return managedType;
    }

    private Attribute<?, ?> resolveAttributeByName(ManagedType<?> managedType, String attributeName) {
        return managedType.getAttributes().stream().filter(attribute -> attribute.getName().equals(attributeName)).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"managedType"})
    @Generated
    public JpaEntityAttributeResolver(ManagedType<?> managedType) {
        this.managedType = managedType;
    }
}

