/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.converter;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.ManagedType;
import lombok.Generated;
import net.croz.nrich.search.api.converter.StringToEntityPropertyMapConverter;
import net.croz.nrich.search.api.converter.StringToTypeConverter;
import net.croz.nrich.search.model.AttributeHolder;
import net.croz.nrich.search.support.JpaEntityAttributeResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultStringToEntityPropertyMapConverter
implements StringToEntityPropertyMapConverter {
    private final List<StringToTypeConverter<?>> converterList;

    public Map<String, Object> convert(String value, List<String> propertyToSearchList, ManagedType<?> managedType) {
        if (value == null || CollectionUtils.isEmpty(propertyToSearchList)) {
            return Collections.emptyMap();
        }
        Assert.notNull(managedType, (String)"Managed type cannot be null!");
        JpaEntityAttributeResolver attributeResolver = new JpaEntityAttributeResolver(managedType);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        propertyToSearchList.forEach(property -> {
            AttributeHolder attributeHolder = attributeResolver.resolveAttributeByPath((String)property);
            if (attributeHolder.getAttribute() == null) {
                return;
            }
            Object convertedValue = this.doConversion(value, attributeHolder.getAttribute().getJavaType());
            resultMap.put((String)property, convertedValue);
        });
        return resultMap;
    }

    private Object doConversion(String searchTerm, Class<?> attributeType) {
        if (String.class.isAssignableFrom(attributeType)) {
            return searchTerm;
        }
        StringToTypeConverter converter = this.converterList.stream().filter(value -> value.supports(attributeType)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No converter found for attribute type %s", attributeType.getName())));
        return converter.convert(searchTerm, attributeType);
    }

    @ConstructorProperties(value={"converterList"})
    @Generated
    public DefaultStringToEntityPropertyMapConverter(List<StringToTypeConverter<?>> converterList) {
        this.converterList = converterList;
    }
}

