/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.api.model.operator;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Collection;
import java.util.Objects;
import net.croz.nrich.search.api.model.operator.SearchOperator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DefaultSearchOperator implements SearchOperator
{
    CONTAINS{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.like(criteriaBuilder.lower(path), "%" + Objects.requireNonNull(value).toString().toLowerCase() + "%");
        }
    }
    ,
    ILIKE{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.like(criteriaBuilder.lower(path), Objects.requireNonNull(value).toString().toLowerCase() + "%");
        }
    }
    ,
    LIKE{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.like(path, Objects.requireNonNull(value) + "%");
        }
    }
    ,
    EQ{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.equal(path, value);
        }
    }
    ,
    GE{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.greaterThanOrEqualTo(path, (Comparable)value);
        }
    }
    ,
    LE{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.lessThanOrEqualTo(path, (Comparable)value);
        }
    }
    ,
    GT{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.greaterThan(path, (Comparable)value);
        }
    }
    ,
    LT{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            return criteriaBuilder.lessThan(path, (Comparable)value);
        }
    }
    ,
    IN{

        @Override
        public Predicate asPredicate(CriteriaBuilder criteriaBuilder, Path<?> path, Object value) {
            CriteriaBuilder.In inClause = criteriaBuilder.in(path);
            ((Collection)value).forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            return inClause;
        }
    };

}

