/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.api.model;

import jakarta.persistence.criteria.JoinType;
import java.beans.ConstructorProperties;
import java.util.function.Predicate;
import lombok.Generated;

public class SearchJoin<R> {
    private final String path;
    private String alias;
    private JoinType joinType;
    private Predicate<R> condition;
    private boolean fetch;

    public static <R> SearchJoin<R> innerJoin(String path) {
        return new SearchJoin<R>(path, path, JoinType.INNER, null, false);
    }

    public static <R> SearchJoin<R> leftJoin(String path) {
        return new SearchJoin<R>(path, path, JoinType.LEFT, null, false);
    }

    public static <R> SearchJoin<R> innerJoinFetch(String path) {
        return new SearchJoin<R>(path, path, JoinType.INNER, null, true);
    }

    public static <R> SearchJoin<R> leftJoinFetch(String path) {
        return new SearchJoin<R>(path, path, JoinType.LEFT, null, true);
    }

    @Generated
    public static <R> SearchJoinBuilder<R> builder() {
        return new SearchJoinBuilder();
    }

    @ConstructorProperties(value={"path"})
    @Generated
    public SearchJoin(String path) {
        this.path = path;
    }

    @ConstructorProperties(value={"path", "alias", "joinType", "condition", "fetch"})
    @Generated
    public SearchJoin(String path, String alias, JoinType joinType, Predicate<R> condition, boolean fetch) {
        this.path = path;
        this.alias = alias;
        this.joinType = joinType;
        this.condition = condition;
        this.fetch = fetch;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Generated
    public Predicate<R> getCondition() {
        return this.condition;
    }

    @Generated
    public boolean isFetch() {
        return this.fetch;
    }

    @Generated
    public static class SearchJoinBuilder<R> {
        @Generated
        private String path;
        @Generated
        private String alias;
        @Generated
        private JoinType joinType;
        @Generated
        private Predicate<R> condition;
        @Generated
        private boolean fetch;

        @Generated
        SearchJoinBuilder() {
        }

        @Generated
        public SearchJoinBuilder<R> path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public SearchJoinBuilder<R> alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public SearchJoinBuilder<R> joinType(JoinType joinType) {
            this.joinType = joinType;
            return this;
        }

        @Generated
        public SearchJoinBuilder<R> condition(Predicate<R> condition) {
            this.condition = condition;
            return this;
        }

        @Generated
        public SearchJoinBuilder<R> fetch(boolean fetch) {
            this.fetch = fetch;
            return this;
        }

        @Generated
        public SearchJoin<R> build() {
            return new SearchJoin<R>(this.path, this.alias, this.joinType, this.condition, this.fetch);
        }

        @Generated
        public String toString() {
            return "SearchJoin.SearchJoinBuilder(path=" + this.path + ", alias=" + this.alias + ", joinType=" + this.joinType + ", condition=" + this.condition + ", fetch=" + this.fetch + ")";
        }
    }
}

