/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.enumdata.service;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.registry.api.enumdata.model.EnumResult;
import net.croz.nrich.registry.api.enumdata.request.ListBulkRegistryEnumRequest;
import net.croz.nrich.registry.api.enumdata.request.ListRegistryEnumRequest;
import net.croz.nrich.registry.api.enumdata.service.RegistryEnumService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultRegistryEnumService
implements RegistryEnumService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRegistryEnumService.class);
    private static final String ADDITIONAL_METHODS_FOR_SERIALIZATION_PROPERTY_NAME = "ADDITIONAL_METHODS_FOR_SERIALIZATION";
    private static final String ENUM_DESCRIPTION_MESSAGE_FORMAT = "%s.%s.description";
    private final MessageSource messageSource;

    public Map<String, List<EnumResult>> listBulk(ListBulkRegistryEnumRequest request) {
        return request.registryRequestList().stream().collect(Collectors.toMap(ListRegistryEnumRequest::classFullName, this::list));
    }

    public List<EnumResult> list(ListRegistryEnumRequest request) {
        boolean isEmptyQuery = !StringUtils.hasText((String)request.query());
        List<EnumResult> enumResults = this.loadEnumRegistry(request.classFullName(), LocaleContextHolder.getLocale());
        ArrayList<EnumResult> foundEnums = new ArrayList<EnumResult>();
        enumResults.forEach(enumResult -> {
            if (isEmptyQuery || enumResult.description().toLowerCase().contains(request.query().toLowerCase())) {
                foundEnums.add((EnumResult)enumResult);
            }
        });
        return foundEnums;
    }

    private List<EnumResult> loadEnumRegistry(String enumClassName, Locale locale) {
        Class<Enum<?>> enumType = this.loadEnumClass(enumClassName);
        if (enumType == null || !Enum.class.isAssignableFrom(enumType)) {
            return Collections.emptyList();
        }
        List<String> additionalRegistryMethodsForSerialization = this.findAdditionalMethodsForSerialization(enumType);
        return Arrays.stream(enumType.getEnumConstants()).map(enumValue -> {
            String description = this.resolveMessage(String.format(ENUM_DESCRIPTION_MESSAGE_FORMAT, enumClassName, enumValue.name()), enumValue.name(), locale);
            Map<String, Object> additionalEnumData = this.serializeAdditionalEnumData(enumType, (Enum<?>)enumValue, additionalRegistryMethodsForSerialization);
            return new EnumResult(enumClassName, description, enumValue, additionalEnumData);
        }).toList();
    }

    private String resolveMessage(String code, String defaultValue, Locale locale) {
        String message;
        try {
            message = this.messageSource.getMessage(code, null, locale);
        }
        catch (NoSuchMessageException exception) {
            log.debug("Message not found for enum under code: {}, returning default value: {}", (Object)code, (Object)defaultValue);
            message = defaultValue;
        }
        return message;
    }

    private Class<? extends Enum<?>> loadEnumClass(String enumClassName) {
        try {
            return Class.forName(enumClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private List<String> findAdditionalMethodsForSerialization(Class<? extends Enum<?>> enumType) {
        Field field = ReflectionUtils.findField(enumType, (String)ADDITIONAL_METHODS_FOR_SERIALIZATION_PROPERTY_NAME);
        if (field == null) {
            return Collections.emptyList();
        }
        return (List)ReflectionUtils.getField((Field)field, null);
    }

    private Map<String, Object> serializeAdditionalEnumData(Class<?> enumType, Enum<?> enumValue, List<String> additionalRegistryMethodsForSerialization) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        additionalRegistryMethodsForSerialization.forEach(methodName -> {
            Object methodResult = this.invokeMethodIfExists(enumType, enumValue, (String)methodName);
            if (methodResult == null) {
                return;
            }
            result.put((String)methodName, methodResult);
        });
        return result;
    }

    private Object invokeMethodIfExists(Class<?> enumType, Object target, String methodName) {
        Method method = ReflectionUtils.findMethod(enumType, (String)methodName);
        if (method == null) {
            return null;
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }

    @ConstructorProperties(value={"messageSource"})
    @Generated
    public DefaultRegistryEnumService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

