/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.controller;

import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import net.croz.nrich.registry.api.data.request.ListBulkRegistryRequest;
import net.croz.nrich.registry.api.data.request.ListRegistryRequest;
import net.croz.nrich.registry.api.data.service.RegistryDataService;
import net.croz.nrich.registry.data.request.CreateRegistryRequest;
import net.croz.nrich.registry.data.request.DeleteRegistryRequest;
import net.croz.nrich.registry.data.request.UpdateRegistryRequest;
import net.croz.nrich.registry.data.service.RegistryDataRequestConversionService;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"${nrich.registry.data.endpoint-path:nrich/registry/data}"})
@RestController
public class RegistryDataController {
    private final RegistryDataService registryDataService;
    private final RegistryDataRequestConversionService registryDataRequestConversionService;
    private final Validator validator;

    @PostMapping(value={"list-bulk"})
    public Map<String, Page<Object>> listBulk(@RequestBody @Valid ListBulkRegistryRequest request) {
        return this.registryDataService.listBulk(request);
    }

    @PostMapping(value={"list"})
    public Page<Object> list(@RequestBody @Valid ListRegistryRequest request) {
        return this.registryDataService.list(request);
    }

    @PostMapping(value={"delete"})
    public void delete(@RequestBody @Valid DeleteRegistryRequest request) {
        this.registryDataService.delete(request.classFullName(), request.id());
    }

    @PostMapping(value={"create"})
    public Object create(@RequestBody @Valid CreateRegistryRequest request) {
        Object entityData = this.registryDataRequestConversionService.convertEntityDataToTyped(request);
        this.validateEntityData("create", CreateRegistryRequest.class, entityData);
        return this.registryDataService.create(request.classFullName(), entityData);
    }

    @PostMapping(value={"update"})
    public Object update(@RequestBody @Valid UpdateRegistryRequest request) {
        Object entityData = this.registryDataRequestConversionService.convertEntityDataToTyped(request);
        this.validateEntityData("update", UpdateRegistryRequest.class, entityData);
        return this.registryDataService.update(request.classFullName(), request.id(), entityData);
    }

    private void validateEntityData(String methodName, Class<?> methodParameter, Object entityData) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(entityData, "entityData");
        this.validator.validate(entityData, (Errors)errors);
        if (errors.hasErrors()) {
            throw new MethodArgumentNotValidException(new MethodParameter(this.getClass().getMethod(methodName, methodParameter), 0), (BindingResult)errors);
        }
    }

    @ConstructorProperties(value={"registryDataService", "registryDataRequestConversionService", "validator"})
    @Generated
    public RegistryDataController(RegistryDataService registryDataService, RegistryDataRequestConversionService registryDataRequestConversionService, Validator validator) {
        this.registryDataService = registryDataService;
        this.registryDataRequestConversionService = registryDataRequestConversionService;
        this.validator = validator;
    }
}

