/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.support;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.registry.core.support.SingularAssociation;
import org.springframework.util.Assert;

public class ManagedTypeWrapper {
    private final IdentifiableType<?> identifiableType;
    private final boolean isIdClassIdentifier;
    private final boolean isEmbeddedIdentifier;
    private final Map<String, Class<?>> idClassPropertyMap;
    private final List<String> idClassPropertyNameList;
    private final String idAttributeName;
    private final boolean isIdentifierAssigned;
    private final List<SingularAssociation> singularAssociationList;
    private final List<SingularAssociation> singularEmbeddedTypeAssociationList;
    private final EmbeddableType<?> embeddableIdType;

    public ManagedTypeWrapper(ManagedType<?> managedType) {
        Assert.isTrue((boolean)(managedType instanceof IdentifiableType), (String)"Managed type has no id attribute, no operations will be possible!");
        this.identifiableType = (IdentifiableType)managedType;
        this.embeddableIdType = this.resolveEmbeddedIdentifierType(this.identifiableType);
        this.isEmbeddedIdentifier = this.embeddableIdType != null;
        this.isIdClassIdentifier = !this.identifiableType.hasSingleIdAttribute();
        this.idAttributeName = this.resolveIdAttributeName(this.identifiableType);
        this.idClassPropertyMap = this.resolveIdClassPropertyMap(this.identifiableType);
        this.idClassPropertyNameList = new ArrayList<String>(this.idClassPropertyMap.keySet());
        this.isIdentifierAssigned = this.resolveIsIdentifierAssigned(this.identifiableType);
        this.singularAssociationList = this.resolveSingularAssociationList((ManagedType<?>)this.identifiableType);
        this.singularEmbeddedTypeAssociationList = this.isEmbeddedIdentifier ? this.resolveSingularAssociationList((ManagedType<?>)this.embeddableIdType) : Collections.emptyList();
    }

    public Class<?> getJavaType() {
        return this.identifiableType.getJavaType();
    }

    private EmbeddableType<?> resolveEmbeddedIdentifierType(IdentifiableType<?> identifiableType) {
        EmbeddableType embeddableType;
        Type type = identifiableType.getIdType();
        return type instanceof EmbeddableType ? (embeddableType = (EmbeddableType)type) : null;
    }

    private String resolveIdAttributeName(IdentifiableType<?> identifiableType) {
        return identifiableType.hasSingleIdAttribute() ? identifiableType.getId(identifiableType.getIdType().getJavaType()).getName() : null;
    }

    private Map<String, Class<?>> resolveIdClassPropertyMap(IdentifiableType<?> identifiableType) {
        return identifiableType.hasSingleIdAttribute() ? Collections.emptyMap() : identifiableType.getIdClassAttributes().stream().collect(Collectors.toMap(Attribute::getName, Attribute::getJavaType));
    }

    private boolean resolveIsIdentifierAssigned(IdentifiableType<?> managedType) {
        return managedType.getAttributes().stream().map(Attribute::getJavaMember).filter(Field.class::isInstance).map(Field.class::cast).map(Field::getDeclaredAnnotations).noneMatch(annotationList -> Arrays.stream(annotationList).anyMatch(annotation -> GeneratedValue.class.equals(annotation.annotationType())));
    }

    private List<SingularAssociation> resolveSingularAssociationList(ManagedType<?> managedType) {
        HashMap<String, SingularAssociation> associationMap = new HashMap<String, SingularAssociation>();
        this.resolveSingularAssociationList(managedType, null, null, associationMap);
        return new ArrayList<SingularAssociation>(associationMap.values());
    }

    private void resolveSingularAssociationList(ManagedType<?> managedType, Boolean isCurrentAssociationPathOptional, String currentPrefix, Map<String, SingularAssociation> singularAssociationMap) {
        List<SingularAttribute> currentAssociations = managedType.getSingularAttributes().stream().filter(Attribute::isAssociation).toList();
        for (SingularAttribute association : currentAssociations) {
            String associationName;
            String string = associationName = currentPrefix == null ? association.getName() : String.format("%s.%s", currentPrefix, association.getName());
            boolean isCurrentPathOptional = isCurrentAssociationPathOptional == null ? association.isOptional() : isCurrentAssociationPathOptional != false || association.isOptional();
            singularAssociationMap.put(associationName, new SingularAssociation(associationName, isCurrentPathOptional));
            if (currentPrefix != null) {
                singularAssociationMap.remove(currentPrefix);
            }
            if (association.getJavaType().equals(managedType.getJavaType())) continue;
            this.resolveSingularAssociationList((ManagedType)association.getType(), association.isOptional(), associationName, singularAssociationMap);
        }
    }

    @Generated
    public IdentifiableType<?> getIdentifiableType() {
        return this.identifiableType;
    }

    @Generated
    public boolean isIdClassIdentifier() {
        return this.isIdClassIdentifier;
    }

    @Generated
    public boolean isEmbeddedIdentifier() {
        return this.isEmbeddedIdentifier;
    }

    @Generated
    public Map<String, Class<?>> getIdClassPropertyMap() {
        return this.idClassPropertyMap;
    }

    @Generated
    public List<String> getIdClassPropertyNameList() {
        return this.idClassPropertyNameList;
    }

    @Generated
    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    @Generated
    public boolean isIdentifierAssigned() {
        return this.isIdentifierAssigned;
    }

    @Generated
    public List<SingularAssociation> getSingularAssociationList() {
        return this.singularAssociationList;
    }

    @Generated
    public List<SingularAssociation> getSingularEmbeddedTypeAssociationList() {
        return this.singularEmbeddedTypeAssociationList;
    }

    @Generated
    public EmbeddableType<?> getEmbeddableIdType() {
        return this.embeddableIdType;
    }
}

