/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.croz.nrich.registry.api.core.model.RegistryConfiguration;
import net.croz.nrich.registry.api.core.model.RegistryOverrideConfiguration;
import net.croz.nrich.registry.api.core.model.RegistryOverrideConfigurationHolder;
import net.croz.nrich.registry.core.model.PropertyWithType;
import net.croz.nrich.registry.core.model.RegistryDataConfiguration;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.core.model.RegistryGroupDefinition;
import net.croz.nrich.registry.core.model.RegistryGroupDefinitionHolder;
import net.croz.nrich.registry.core.model.RegistryHistoryConfigurationHolder;
import net.croz.nrich.registry.core.service.RegistryConfigurationResolverService;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import net.croz.nrich.registry.core.support.SingularAssociation;
import net.croz.nrich.registry.core.util.AnnotationUtil;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.model.SearchJoin;
import org.springframework.util.CollectionUtils;

public class DefaultRegistryConfigurationResolverService
implements RegistryConfigurationResolverService {
    private final EntityManager entityManager;
    private final RegistryConfiguration registryConfiguration;

    @Override
    public RegistryGroupDefinitionHolder resolveRegistryGroupDefinition() {
        Set managedTypeList = this.entityManager.getMetamodel().getManagedTypes();
        ArrayList<RegistryGroupDefinition> registryGroupDefinitionList = new ArrayList<RegistryGroupDefinition>();
        this.registryConfiguration.getGroupDefinitionConfigurationList().forEach(registryGroupDefinition -> {
            List<ManagedTypeWrapper> includedManagedTypeList = managedTypeList.stream().filter(managedType -> this.includeManagedType((ManagedType<?>)managedType, registryGroupDefinition.getIncludeEntityPatternList(), registryGroupDefinition.getExcludeEntityPatternList())).map(ManagedTypeWrapper::new).toList();
            if (CollectionUtils.isEmpty(includedManagedTypeList)) {
                return;
            }
            registryGroupDefinitionList.add(new RegistryGroupDefinition(registryGroupDefinition.getGroupId(), includedManagedTypeList));
        });
        return new RegistryGroupDefinitionHolder(registryGroupDefinitionList, this.registryConfiguration.getGroupDisplayOrderList());
    }

    @Override
    public Map<Class<?>, RegistryOverrideConfiguration> resolveRegistryOverrideConfigurationMap() {
        return Optional.ofNullable(this.registryConfiguration.getOverrideConfigurationHolderList()).orElse(Collections.emptyList()).stream().filter(registryOverrideConfigurationHolder -> registryOverrideConfigurationHolder.getOverrideConfiguration() != null).collect(Collectors.toMap(RegistryOverrideConfigurationHolder::getType, RegistryOverrideConfigurationHolder::getOverrideConfiguration));
    }

    @Override
    public RegistryDataConfigurationHolder resolveRegistryDataConfiguration() {
        RegistryGroupDefinitionHolder groupDefinitionHolder = this.resolveRegistryGroupDefinition();
        List managedTypeWrapperList = groupDefinitionHolder.groupDefinitionList().stream().map(RegistryGroupDefinition::registryEntityList).flatMap(Collection::stream).toList();
        ArrayList<RegistryDataConfiguration<Object, Object>> registryDataConfigurationList = new ArrayList<RegistryDataConfiguration<Object, Object>>();
        managedTypeWrapperList.forEach(managedTypeWrapper -> {
            Class<?> type = managedTypeWrapper.getJavaType();
            registryDataConfigurationList.add(new RegistryDataConfiguration<Object, Object>(type, this.resolveSearchConfiguration((ManagedTypeWrapper)managedTypeWrapper)));
        });
        Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap = managedTypeWrapperList.stream().collect(Collectors.toMap(value -> value.getJavaType().getName(), Function.identity()));
        return new RegistryDataConfigurationHolder(classNameManagedTypeWrapperMap, registryDataConfigurationList);
    }

    @Override
    public RegistryHistoryConfigurationHolder resolveRegistryHistoryConfiguration() {
        ManagedType revisionEntityManagedType = this.entityManager.getMetamodel().getManagedTypes().stream().filter(managedType -> AnnotationUtil.isAnnotationPresent(managedType.getJavaType(), "org.hibernate.envers.RevisionEntity")).findFirst().orElse(null);
        String revisionNumberPropertyName = "id";
        Class revisionNumberPropertyType = Integer.class;
        String revisionTimestampPropertyName = "timestamp";
        Class revisionTimestampPropertyType = Date.class;
        Set attributes = Optional.ofNullable(revisionEntityManagedType).map(ManagedType::getAttributes).orElse(Collections.emptySet());
        ArrayList<PropertyWithType> additionalPropertyList = new ArrayList<PropertyWithType>();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            Class attributeType = attribute.getJavaType();
            Member member = attribute.getJavaMember();
            if (!(member instanceof Field)) continue;
            Field attributeField = (Field)member;
            if (AnnotationUtil.isAnnotationPresent(attributeField, "org.hibernate.envers.RevisionNumber")) {
                revisionNumberPropertyName = attributeName;
                revisionNumberPropertyType = attributeType;
                continue;
            }
            if (AnnotationUtil.isAnnotationPresent(attributeField, "org.hibernate.envers.RevisionTimestamp")) {
                revisionTimestampPropertyName = attributeName;
                revisionTimestampPropertyType = attributeType;
                continue;
            }
            additionalPropertyList.add(new PropertyWithType(attributeName, attributeName, attributeType));
        }
        PropertyWithType revisionNumberProperty = new PropertyWithType("revisionNumber", revisionNumberPropertyName, revisionNumberPropertyType);
        PropertyWithType revisionTimestampProperty = new PropertyWithType("revisionTimestamp", revisionTimestampPropertyName, revisionTimestampPropertyType);
        PropertyWithType revisionTypeProperty = new PropertyWithType("revisionType", "revisionType", String.class);
        List displayOrderList = this.registryConfiguration.getHistoryDisplayOrderList();
        return new RegistryHistoryConfigurationHolder(revisionNumberProperty, revisionTimestampProperty, revisionTypeProperty, additionalPropertyList, displayOrderList);
    }

    private boolean includeManagedType(ManagedType<?> managedType, List<String> includeDomainPatternList, List<String> excludeDomainPatternList) {
        if (CollectionUtils.isEmpty(includeDomainPatternList) || !(managedType instanceof IdentifiableType) || AnnotationUtil.isAnnotationPresent(managedType.getJavaType(), "org.hibernate.envers.RevisionEntity")) {
            return false;
        }
        String classFullName = managedType.getJavaType().getName();
        boolean includeType = includeDomainPatternList.stream().anyMatch(classFullName::matches);
        if (!includeType || CollectionUtils.isEmpty(excludeDomainPatternList)) {
            return includeType;
        }
        return excludeDomainPatternList.stream().filter(Objects::nonNull).noneMatch(classFullName::matches);
    }

    private SearchConfiguration<Object, Object, Map<String, Object>> resolveSearchConfiguration(ManagedTypeWrapper managedTypeWrapper) {
        Class<?> type = managedTypeWrapper.getJavaType();
        return Optional.ofNullable(this.registryConfiguration.getOverrideConfigurationHolderList()).orElse(Collections.emptyList()).stream().filter(registryOverrideConfigurationHolder -> type.equals(registryOverrideConfigurationHolder.getType()) && registryOverrideConfigurationHolder.getOverrideSearchConfiguration() != null).map(RegistryOverrideConfigurationHolder::getOverrideSearchConfiguration).findFirst().orElse(this.emptySearchConfigurationWithRequiredJoinFetchList(managedTypeWrapper));
    }

    private SearchConfiguration<Object, Object, Map<String, Object>> emptySearchConfigurationWithRequiredJoinFetchList(ManagedTypeWrapper managedTypeWrapper) {
        SearchConfiguration searchConfiguration = SearchConfiguration.emptyConfigurationMatchingAny();
        List<SearchJoin<Map<String, Object>>> searchJoinList = Stream.concat(this.createSearchJoinStreamFromAssociationList(managedTypeWrapper.getSingularAssociationList(), ""), this.createSearchJoinStreamFromAssociationList(managedTypeWrapper.getSingularEmbeddedTypeAssociationList(), managedTypeWrapper.getIdAttributeName() + ".")).toList();
        searchConfiguration.setJoinList(searchJoinList);
        return searchConfiguration;
    }

    private Stream<SearchJoin<Map<String, Object>>> createSearchJoinStreamFromAssociationList(List<SingularAssociation> associationList, String prefix) {
        return associationList.stream().map(attribute -> attribute.optional() ? SearchJoin.leftJoinFetch((String)(prefix + attribute.path())) : SearchJoin.innerJoinFetch((String)(prefix + attribute.path())));
    }

    @ConstructorProperties(value={"entityManager", "registryConfiguration"})
    @Generated
    public DefaultRegistryConfigurationResolverService(EntityManager entityManager, RegistryConfiguration registryConfiguration) {
        this.entityManager = entityManager;
        this.registryConfiguration = registryConfiguration;
    }
}

