/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.croz.nrich.registry.api.core.service.RegistryClassResolvingService;
import net.croz.nrich.registry.core.constants.RegistryClassResolvingConstants;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.data.util.ClassLoadingUtil;
import org.springframework.cache.annotation.Cacheable;

public class DefaultRegistryClassResolvingService
implements RegistryClassResolvingService {
    private final RegistryDataConfigurationHolder registryDataConfigurationHolder;
    private final Map<String, Class<?>> createClassMapping;
    private final Map<String, Class<?>> updateClassMapping;

    public DefaultRegistryClassResolvingService(RegistryDataConfigurationHolder registryDataConfigurationHolder, Map<String, Class<?>> createClassMapping, Map<String, Class<?>> updateClassMapping) {
        this.registryDataConfigurationHolder = registryDataConfigurationHolder;
        this.createClassMapping = Optional.ofNullable(createClassMapping).orElse(Collections.emptyMap());
        this.updateClassMapping = Optional.ofNullable(updateClassMapping).orElse(Collections.emptyMap());
    }

    @Cacheable(value={"nrich.classResolvingCreate.cache"})
    public Class<?> resolveCreateClass(String registryClassName) {
        this.registryDataConfigurationHolder.verifyConfigurationExists(registryClassName);
        if (this.createClassMapping.containsKey(registryClassName)) {
            return this.createClassMapping.get(registryClassName);
        }
        return this.resolveClassByPackage(registryClassName, "%sCreateRequest");
    }

    @Cacheable(value={"nrich.classResolvingUpdate.cache"})
    public Class<?> resolveUpdateClass(String registryClassName) {
        this.registryDataConfigurationHolder.verifyConfigurationExists(registryClassName);
        if (this.updateClassMapping.containsKey(registryClassName)) {
            return this.updateClassMapping.get(registryClassName);
        }
        return this.resolveClassByPackage(registryClassName, "%sUpdateRequest");
    }

    private Class<?> resolveClassByPackage(String registryFullClassName, String requestClassNameFormat) {
        int indexOfLastPackage;
        ArrayList<String> registryClassNameList = new ArrayList<String>(List.of(registryFullClassName.split("\\.")));
        if (RegistryClassResolvingConstants.CLASS_NAME_SUFFIX_LIST_TO_REPLACE.contains(registryClassNameList.get(indexOfLastPackage = registryClassNameList.size() - 2))) {
            registryClassNameList.remove(registryClassNameList.get(indexOfLastPackage));
        }
        registryClassNameList.add(registryClassNameList.size() - 1, "request");
        String fullClassNameWithRequestPackage = String.join((CharSequence)".", registryClassNameList);
        return this.resolveClass(registryFullClassName, fullClassNameWithRequestPackage, requestClassNameFormat);
    }

    private Class<?> resolveClass(String fullClassName, String fullClassNameWithRequestPackage, String requestClassNameFormat) {
        List<String> classNameList = List.of(String.format(requestClassNameFormat, fullClassNameWithRequestPackage), String.format("%sRequest", fullClassNameWithRequestPackage), String.format(requestClassNameFormat, fullClassName), String.format("%sRequest", fullClassName), fullClassName);
        return ClassLoadingUtil.loadClassFromList(classNameList);
    }
}

