/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.croz.nrich.registry.api.core.service.RegistryEntityFinderService;
import net.croz.nrich.registry.api.data.interceptor.RegistryDataInterceptor;
import net.croz.nrich.registry.api.data.request.ListBulkRegistryRequest;
import net.croz.nrich.registry.api.data.request.ListRegistryRequest;
import net.croz.nrich.registry.api.data.service.RegistryDataService;
import net.croz.nrich.registry.core.model.RegistryDataConfiguration;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import net.croz.nrich.registry.data.util.HibernateUtil;
import net.croz.nrich.search.api.converter.StringToEntityPropertyMapConverter;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.model.property.SearchPropertyConfiguration;
import net.croz.nrich.search.api.model.sort.SortDirection;
import net.croz.nrich.search.api.model.sort.SortProperty;
import net.croz.nrich.search.api.util.PageableUtil;
import net.croz.nrich.search.support.JpaQueryBuilder;
import net.croz.nrich.search.util.PathResolvingUtil;
import org.modelmapper.ModelMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

public class DefaultRegistryDataService
implements RegistryDataService {
    private final EntityManager entityManager;
    private final ModelMapper modelMapper;
    private final StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter;
    private final RegistryDataConfigurationHolder registryDataConfigurationHolder;
    private final List<RegistryDataInterceptor> registryDataInterceptorList;
    private final Map<String, JpaQueryBuilder<?>> classNameQueryBuilderMap;
    private final RegistryEntityFinderService registryEntityFinderService;

    public DefaultRegistryDataService(EntityManager entityManager, ModelMapper modelMapper, StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter, RegistryDataConfigurationHolder registryDataConfigurationHolder, List<RegistryDataInterceptor> registryDataInterceptorList, RegistryEntityFinderService registryEntityFinderService) {
        this.entityManager = entityManager;
        this.modelMapper = modelMapper;
        this.stringToEntityPropertyMapConverter = stringToEntityPropertyMapConverter;
        this.registryDataConfigurationHolder = registryDataConfigurationHolder;
        this.registryDataInterceptorList = registryDataInterceptorList;
        this.classNameQueryBuilderMap = this.initializeQueryBuilderMap(registryDataConfigurationHolder);
        this.registryEntityFinderService = registryEntityFinderService;
    }

    @Transactional(readOnly=true)
    public Map<String, Page<Object>> listBulk(ListBulkRegistryRequest request) {
        return request.registryRequestList().stream().collect(Collectors.toMap(ListRegistryRequest::classFullName, this::list));
    }

    @Transactional(readOnly=true)
    public <P> Page<P> list(ListRegistryRequest request) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryList(request));
        return this.registryListInternal(request);
    }

    @Transactional
    public <T> T create(String classFullName, Object entityData) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryCreate(classFullName, entityData));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        Object instance = this.resolveEntityInstance(registryDataConfiguration.registryType(), entityData);
        this.modelMapper.map(entityData, instance);
        return (T)this.mergeAndInitializeEntity(instance);
    }

    @Transactional
    public <T> T update(String classFullName, Object id, Object entityData) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryUpdate(classFullName, id, entityData));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        ManagedTypeWrapper wrapper = this.registryDataConfigurationHolder.resolveManagedTypeWrapper(classFullName);
        Object instance = this.registryEntityFinderService.findEntityInstance(registryDataConfiguration.registryType(), id);
        if (wrapper.isIdClassIdentifier() || wrapper.isEmbeddedIdentifier()) {
            this.entityManager.remove(instance);
            instance = this.resolveEntityInstance(registryDataConfiguration.registryType(), entityData);
        } else {
            this.setIdFieldToOriginalValue(wrapper, entityData, id);
        }
        this.clearAssociationValues(wrapper, instance, entityData);
        this.modelMapper.map(entityData, instance);
        return (T)this.mergeAndInitializeEntity(instance);
    }

    @Transactional
    public <T> T delete(String classFullName, Object id) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryDelete(classFullName, id));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        Object instance = this.registryEntityFinderService.findEntityInstance(registryDataConfiguration.registryType(), id);
        this.entityManager.remove(instance);
        return (T)instance;
    }

    private Map<String, JpaQueryBuilder<?>> initializeQueryBuilderMap(RegistryDataConfigurationHolder registryDataConfigurationHolder) {
        return registryDataConfigurationHolder.registryDataConfigurationList().stream().collect(Collectors.toMap(registryDataConfiguration -> registryDataConfiguration.registryType().getName(), registryDataConfiguration -> new JpaQueryBuilder(this.entityManager, registryDataConfiguration.registryType())));
    }

    private List<RegistryDataInterceptor> interceptorList() {
        return Optional.ofNullable(this.registryDataInterceptorList).orElse(Collections.emptyList());
    }

    private <T, P> Page<P> registryListInternal(ListRegistryRequest request) {
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(request.classFullName());
        SearchConfiguration<Object, Object, Map<String, Object>> searchConfiguration = registryDataConfiguration.searchConfiguration();
        JpaQueryBuilder<?> queryBuilder = this.classNameQueryBuilderMap.get(request.classFullName());
        ManagedTypeWrapper managedTypeWrapper = this.registryDataConfigurationHolder.resolveManagedTypeWrapper(request.classFullName());
        String idAttributeName = Optional.ofNullable(managedTypeWrapper.getIdAttributeName()).orElseGet(() -> managedTypeWrapper.getIdClassPropertyNameList().get(0));
        Pageable pageable = PageableUtil.convertToPageable((Integer)request.pageNumber(), (Integer)request.pageSize(), (SortProperty)new SortProperty(idAttributeName, SortDirection.ASC), (List)request.sortPropertyList());
        Map<String, Object> searchRequestMap = this.resolveSearchRequestMap(managedTypeWrapper, request, searchConfiguration.getSearchPropertyConfiguration());
        CriteriaQuery query = queryBuilder.buildQuery(searchRequestMap, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(queryBuilder, searchRequestMap, searchConfiguration));
    }

    private Map<String, Object> resolveSearchRequestMap(ManagedTypeWrapper managedTypeWrapper, ListRegistryRequest request, SearchPropertyConfiguration searchPropertyConfiguration) {
        Map searchRequestMap = Collections.emptyMap();
        if (request.searchParameter() != null) {
            searchRequestMap = this.stringToEntityPropertyMapConverter.convert(request.searchParameter().query(), request.searchParameter().propertyNameList(), managedTypeWrapper.getIdentifiableType(), searchPropertyConfiguration);
        }
        return searchRequestMap;
    }

    private <T, P> long executeCountQuery(JpaQueryBuilder<T> queryBuilder, Map<String, Object> searchRequestMap, SearchConfiguration<T, P, Map<String, Object>> searchConfiguration) {
        CriteriaQuery countQuery = queryBuilder.buildCountQuery(searchRequestMap, searchConfiguration);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return totals.stream().mapToLong(value -> value == null ? 0L : value).sum();
    }

    private <T> T resolveEntityInstance(Class<T> type, Object entityData) {
        if (entityData != null && type.equals(entityData.getClass())) {
            return (T)entityData;
        }
        return (T)BeanUtils.instantiateClass(type);
    }

    private void setIdFieldToOriginalValue(ManagedTypeWrapper managedTypeWrapper, Object entityData, Object id) {
        Map<String, Object> idValueMap = Collections.singletonMap(managedTypeWrapper.getIdAttributeName(), id);
        this.modelMapper.map(idValueMap, entityData);
    }

    private void clearAssociationValues(ManagedTypeWrapper managedTypeWrapper, Object instance, Object entityData) {
        Set<String> associationList = managedTypeWrapper.getSingularAssociationList().stream().map(association -> PathResolvingUtil.convertToPathList((String)association.path())[0]).collect(Collectors.toSet());
        associationList.forEach(association -> this.clearValue(instance, entityData, (String)association));
    }

    private <T> T mergeAndInitializeEntity(T instance) {
        Object mergedInstance = this.entityManager.merge(instance);
        HibernateUtil.initialize(mergedInstance);
        return (T)mergedInstance;
    }

    private void clearValue(Object instance, Object entityData, String path) {
        BeanWrapper entityDataWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entityData);
        if (entityDataWrapper.isReadableProperty(path) && entityDataWrapper.getPropertyValue(path) != null) {
            PropertyAccessorFactory.forBeanPropertyAccess((Object)instance).setPropertyValue(path, null);
        }
    }
}

