/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.registry.api.core.service.RegistryEntityFinderService;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import org.modelmapper.ModelMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EntityManagerRegistryEntityFinderService
implements RegistryEntityFinderService {
    private final EntityManager entityManager;
    private final ModelMapper modelMapper;
    private final Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap;

    public <T> T findEntityInstance(Class<T> type, Object id) {
        QueryCondition queryCondition = this.queryWherePartWithParameterMap(type, id, true);
        String entityWithAlias = String.format(" %s %s ", type.getName(), "entity");
        String fullQuery = String.format("select entity from %s where %s", entityWithAlias, queryCondition.wherePart);
        TypedQuery query = (TypedQuery)this.entityManager.createQuery(fullQuery);
        queryCondition.parameterMap.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        return (T)query.getSingleResult();
    }

    public <T> Map<String, Object> resolveIdParameterMap(Class<T> type, Object id) {
        return this.queryWherePartWithParameterMap(type, (Object)id, (boolean)false).parameterMap;
    }

    private <T> QueryCondition queryWherePartWithParameterMap(Class<T> type, Object id, boolean convertParameterToQueryFormat) {
        ManagedTypeWrapper managedTypeWrapper = this.classNameManagedTypeWrapperMap.get(type.getName());
        ArrayList<String> wherePartList = new ArrayList<String>();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (managedTypeWrapper.isIdClassIdentifier()) {
            Assert.isTrue((boolean)(id instanceof Map), (String)"Id should be instance of Map for @IdClass identifier");
            Map<String, Object> idMap = ((Map)id).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), Map.Entry::getValue));
            Map<String, Class<?>> idClassPropertyMap = managedTypeWrapper.getIdClassPropertyMap();
            idClassPropertyMap.forEach((key, value) -> {
                Object convertedIdValue = this.modelMapper.map(idMap.get(key), value);
                wherePartList.add(this.toParameterExpression((String)key, convertParameterToQueryFormat));
                parameterMap.put(this.toParameterVariable((String)key, convertParameterToQueryFormat), convertedIdValue);
            });
        } else {
            Object convertedIdValue;
            if (managedTypeWrapper.isEmbeddedIdentifier()) {
                boolean isMapOrEmbeddedId = id instanceof Map || managedTypeWrapper.getEmbeddableIdType().getJavaType().equals(id.getClass());
                Assert.isTrue((boolean)isMapOrEmbeddedId, (String)"Id should be instance of Map or EmbeddedId for @EmbeddedId identifier");
                convertedIdValue = this.modelMapper.map(id, managedTypeWrapper.getEmbeddableIdType().getJavaType());
            } else {
                convertedIdValue = this.modelMapper.map(id, managedTypeWrapper.getIdentifiableType().getIdType().getJavaType());
            }
            String idAttributeName = managedTypeWrapper.getIdAttributeName();
            wherePartList.add(this.toParameterExpression(idAttributeName, convertParameterToQueryFormat));
            parameterMap.put(this.toParameterVariable(idAttributeName, convertParameterToQueryFormat), convertedIdValue);
        }
        return new QueryCondition(String.join((CharSequence)" and ", wherePartList), parameterMap);
    }

    private String toParameterExpression(String key, boolean convertParameterToQueryFormat) {
        return String.format("entity.%s = :%s", key, this.toParameterVariable(key, convertParameterToQueryFormat));
    }

    private String toParameterVariable(String key, boolean convertParameterToQueryFormat) {
        if (!convertParameterToQueryFormat) {
            return key;
        }
        String[] keyList = key.split("\\.");
        return Arrays.stream(keyList).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    @ConstructorProperties(value={"entityManager", "modelMapper", "classNameManagedTypeWrapperMap"})
    @Generated
    public EntityManagerRegistryEntityFinderService(EntityManager entityManager, ModelMapper modelMapper, Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap) {
        this.entityManager = entityManager;
        this.modelMapper = modelMapper;
        this.classNameManagedTypeWrapperMap = classNameManagedTypeWrapperMap;
    }

    private record QueryCondition(String wherePart, Map<String, Object> parameterMap) {
    }
}

