/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.security.interceptor;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import net.croz.nrich.registry.api.core.model.RegistryOverrideConfiguration;
import net.croz.nrich.registry.api.data.interceptor.BaseRegistryDataInterceptor;
import net.croz.nrich.registry.api.security.exception.RegistryUpdateNotAllowedException;

public class RegistryConfigurationUpdateInterceptor
extends BaseRegistryDataInterceptor {
    private final Map<String, RegistryOverrideConfiguration> registryOverrideConfigurationMap;

    public RegistryConfigurationUpdateInterceptor(Map<Class<?>, RegistryOverrideConfiguration> registryOverrideConfigurationMap) {
        this.registryOverrideConfigurationMap = this.initializeRegistryOverrideConfigurationMap(registryOverrideConfigurationMap);
    }

    public void beforeRegistryCreate(String classFullName, Object entityData) {
        RegistryOverrideConfiguration registryOverrideConfiguration = this.resolveConfiguration(classFullName);
        this.verifyRegistryOperation(classFullName, registryOverrideConfiguration.isReadOnly() || !registryOverrideConfiguration.isCreatable());
    }

    public void beforeRegistryUpdate(String classFullName, Object id, Object entityData) {
        RegistryOverrideConfiguration registryOverrideConfiguration = this.resolveConfiguration(classFullName);
        this.verifyRegistryOperation(classFullName, registryOverrideConfiguration.isReadOnly() || !registryOverrideConfiguration.isUpdateable());
    }

    public void beforeRegistryDelete(String classFullName, Object id) {
        RegistryOverrideConfiguration registryOverrideConfiguration = this.resolveConfiguration(classFullName);
        this.verifyRegistryOperation(classFullName, registryOverrideConfiguration.isReadOnly() || !registryOverrideConfiguration.isDeletable());
    }

    private RegistryOverrideConfiguration resolveConfiguration(String classFullName) {
        if (this.registryOverrideConfigurationMap.get(classFullName) == null) {
            return new RegistryOverrideConfiguration();
        }
        return this.registryOverrideConfigurationMap.get(classFullName);
    }

    private Map<String, RegistryOverrideConfiguration> initializeRegistryOverrideConfigurationMap(Map<Class<?>, RegistryOverrideConfiguration> registryOverrideConfigurationMap) {
        if (registryOverrideConfigurationMap == null) {
            return Collections.emptyMap();
        }
        return registryOverrideConfigurationMap.entrySet().stream().collect(Collectors.toMap(entry -> ((Class)entry.getKey()).getName(), Map.Entry::getValue));
    }

    private void verifyRegistryOperation(String registryClassName, boolean isNotAllowed) {
        if (isNotAllowed) {
            throw new RegistryUpdateNotAllowedException(String.format("Trying to edit registry: %s that is not editable", registryClassName));
        }
    }
}

