/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.customizer;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.customizer.FormConfigurationMappingCustomizer;
import net.croz.nrich.registry.api.core.service.RegistryClassResolvingService;

public class RegistryDataFormConfigurationMappingCustomizer
implements FormConfigurationMappingCustomizer {
    private final RegistryClassResolvingService registryClassResolvingService;
    private final List<Class<?>> registryClassList;

    public void customizeConfigurationMapping(Map<String, Class<?>> formConfigurationMapping) {
        this.registerRegistryFormConfiguration(formConfigurationMapping);
    }

    private void registerRegistryFormConfiguration(Map<String, Class<?>> formConfigurationMap) {
        this.registryClassList.forEach(registryClass -> {
            String registryClassName = registryClass.getName();
            String registryCreateFormId = String.format("%s:::%s", registryClassName, "create");
            String registryUpdateFormId = String.format("%s:::%s", registryClassName, "update");
            formConfigurationMap.computeIfAbsent(registryCreateFormId, key -> this.registryClassResolvingService.resolveCreateClass(registryClassName));
            formConfigurationMap.computeIfAbsent(registryUpdateFormId, key -> this.registryClassResolvingService.resolveUpdateClass(registryClassName));
        });
    }

    @ConstructorProperties(value={"registryClassResolvingService", "registryClassList"})
    @Generated
    public RegistryDataFormConfigurationMappingCustomizer(RegistryClassResolvingService registryClassResolvingService, List<Class<?>> registryClassList) {
        this.registryClassResolvingService = registryClassResolvingService;
        this.registryClassList = registryClassList;
    }
}

