/*
 *  Copyright 2020-2023 CROZ d.o.o, the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package net.croz.nrich.registry.core.constants;

public final class RegistryEnversConstants {

    public static final String ENVERS_AUDITED_ANNOTATION = "org.hibernate.envers.Audited";

    public static final String ENVERS_REVISION_ENTITY_ANNOTATION = "org.hibernate.envers.RevisionEntity";

    public static final String ENVERS_REVISION_TIMESTAMP_ANNOTATION = "org.hibernate.envers.RevisionTimestamp";

    public static final String ENVERS_REVISION_NUMBER_ANNOTATION = "org.hibernate.envers.RevisionNumber";

    public static final String REVISION_TIMESTAMP_PROPERTY_NAME = "revisionTimestamp";

    public static final String REVISION_NUMBER_PROPERTY_NAME = "revisionNumber";

    public static final String REVISION_TIMESTAMP_PROPERTY_DEFAULT_ORIGINAL_NAME = "timestamp";

    public static final String REVISION_NUMBER_PROPERTY_DEFAULT_ORIGINAL_NAME = "id";

    public static final String REVISION_TYPE_PROPERTY_NAME = "revisionType";

    private RegistryEnversConstants() {
    }
}
