/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.util;

import jakarta.persistence.Entity;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.BeanUtils;

public final class HibernateUtil {
    private static final String PROPERTY_PATH_FORMAT = "%s.%s";
    private static final String COLLECTION_ELEMENT_NAME_FORMAT = "%s-%s";

    private HibernateUtil() {
    }

    public static void initialize(Object entity) {
        HibernateUtil.initializeInternal(entity, null, new ArrayList<String>());
    }

    private static void initializeInternal(Object entity, String propertyPath, List<String> alreadyInitializedProperties) {
        if (entity == null || alreadyInitializedProperties.contains(propertyPath)) {
            return;
        }
        Class<?> entityType = HibernateUtil.resolveEntityType(entity);
        if (!HibernateUtil.isManagedType(entityType)) {
            return;
        }
        if (!Hibernate.isInitialized((Object)entity)) {
            Hibernate.initialize((Object)entity);
        }
        alreadyInitializedProperties.add(propertyPath);
        Arrays.stream(BeanUtils.getPropertyDescriptors(entityType)).forEach(propertyDescriptor -> {
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = HibernateUtil.getPropertyValue(entity, propertyDescriptor);
            if (propertyValue instanceof Collection) {
                Collection collection = (Collection)propertyValue;
                int index = 0;
                for (Object collectionElementValue : collection) {
                    String collectionElementPropertyName = String.format(COLLECTION_ELEMENT_NAME_FORMAT, propertyName, index++);
                    String calculatedPropertyPath = HibernateUtil.calculatePropertyPath(propertyPath, collectionElementPropertyName);
                    HibernateUtil.initializeInternal(collectionElementValue, calculatedPropertyPath, alreadyInitializedProperties);
                }
            } else {
                String calculatedPropertyPath = HibernateUtil.calculatePropertyPath(propertyPath, propertyName);
                HibernateUtil.initializeInternal(propertyValue, calculatedPropertyPath, alreadyInitializedProperties);
            }
        });
    }

    private static Object getPropertyValue(Object entity, PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            return null;
        }
        return method.invoke(entity, new Object[0]);
    }

    private static Class<?> resolveEntityType(Object entity) {
        Class type = entity.getClass();
        if (entity instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)entity;
            type = hibernateProxy.getHibernateLazyInitializer().getPersistentClass();
        }
        return type;
    }

    private static boolean isManagedType(Class<?> entityType) {
        return entityType.getAnnotation(Entity.class) != null;
    }

    private static String calculatePropertyPath(String existingPropertyPath, String propertyName) {
        return existingPropertyPath == null ? propertyName : String.format(PROPERTY_PATH_FORMAT, existingPropertyPath, propertyName);
    }
}

