/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.service;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import net.croz.nrich.registry.api.core.service.RegistryEntityFinderService;
import net.croz.nrich.registry.api.data.interceptor.RegistryDataInterceptor;
import net.croz.nrich.registry.api.data.request.ListBulkRegistryRequest;
import net.croz.nrich.registry.api.data.request.ListRegistryRequest;
import net.croz.nrich.registry.api.data.service.RegistryDataService;
import net.croz.nrich.registry.core.model.RegistryDataConfiguration;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import net.croz.nrich.search.api.converter.StringToEntityPropertyMapConverter;
import net.croz.nrich.search.api.model.SearchConfiguration;
import net.croz.nrich.search.api.model.sort.SortDirection;
import net.croz.nrich.search.api.model.sort.SortProperty;
import net.croz.nrich.search.api.util.PageableUtil;
import net.croz.nrich.search.support.JpaQueryBuilder;
import org.modelmapper.ModelMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class DefaultRegistryDataService
implements RegistryDataService {
    private final EntityManager entityManager;
    private final ModelMapper modelMapper;
    private final StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter;
    private final RegistryDataConfigurationHolder registryDataConfigurationHolder;
    private final List<RegistryDataInterceptor> registryDataInterceptorList;
    private final Map<String, JpaQueryBuilder<?>> classNameQueryBuilderMap;
    private final RegistryEntityFinderService registryEntityFinderService;

    public DefaultRegistryDataService(EntityManager entityManager, ModelMapper modelMapper, StringToEntityPropertyMapConverter stringToEntityPropertyMapConverter, RegistryDataConfigurationHolder registryDataConfigurationHolder, List<RegistryDataInterceptor> registryDataInterceptorList, RegistryEntityFinderService registryEntityFinderService) {
        this.entityManager = entityManager;
        this.modelMapper = modelMapper;
        this.stringToEntityPropertyMapConverter = stringToEntityPropertyMapConverter;
        this.registryDataConfigurationHolder = registryDataConfigurationHolder;
        this.registryDataInterceptorList = registryDataInterceptorList;
        this.classNameQueryBuilderMap = this.initializeQueryBuilderMap(registryDataConfigurationHolder);
        this.registryEntityFinderService = registryEntityFinderService;
    }

    @Transactional(readOnly=true)
    public Map<String, Page<Object>> listBulk(ListBulkRegistryRequest request) {
        return request.getRegistryRequestList().stream().collect(Collectors.toMap(ListRegistryRequest::getClassFullName, this::list));
    }

    @Transactional(readOnly=true)
    public <P> Page<P> list(ListRegistryRequest request) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryList(request));
        return this.registryListInternal(request);
    }

    @Transactional
    public <T> T create(String classFullName, Object entityData) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryCreate(classFullName, entityData));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        Object instance = this.resolveEntityInstance(registryDataConfiguration.getRegistryType(), entityData);
        this.modelMapper.map(entityData, instance);
        return (T)this.entityManager.merge(instance);
    }

    @Transactional
    public <T> T update(String classFullName, Object id, Object entityData) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryUpdate(classFullName, id, entityData));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        ManagedTypeWrapper wrapper = this.registryDataConfigurationHolder.resolveManagedTypeWrapper(classFullName);
        Object instance = this.registryEntityFinderService.findEntityInstance(registryDataConfiguration.getRegistryType(), id);
        if (wrapper.isIdClassIdentifier() || wrapper.isEmbeddedIdentifier()) {
            this.entityManager.remove(instance);
            instance = this.resolveEntityInstance(registryDataConfiguration.getRegistryType(), entityData);
            this.modelMapper.map(entityData, instance);
        } else {
            this.setIdFieldToOriginalValue(wrapper, entityData, id);
            this.modelMapper.map(entityData, instance);
        }
        return (T)this.entityManager.merge(instance);
    }

    @Transactional
    public <T> T delete(String classFullName, Object id) {
        this.interceptorList().forEach(registryDataInterceptor -> registryDataInterceptor.beforeRegistryDelete(classFullName, id));
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(classFullName);
        Object instance = this.registryEntityFinderService.findEntityInstance(registryDataConfiguration.getRegistryType(), id);
        this.entityManager.remove(instance);
        return (T)instance;
    }

    private Map<String, JpaQueryBuilder<?>> initializeQueryBuilderMap(RegistryDataConfigurationHolder registryDataConfigurationHolder) {
        return registryDataConfigurationHolder.getRegistryDataConfigurationList().stream().collect(Collectors.toMap(registryDataConfiguration -> registryDataConfiguration.getRegistryType().getName(), registryDataConfiguration -> new JpaQueryBuilder(this.entityManager, registryDataConfiguration.getRegistryType())));
    }

    private List<RegistryDataInterceptor> interceptorList() {
        return Optional.ofNullable(this.registryDataInterceptorList).orElse(Collections.emptyList());
    }

    private <T, P> Page<P> registryListInternal(ListRegistryRequest request) {
        RegistryDataConfiguration<Object, Object> registryDataConfiguration = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(request.getClassFullName());
        SearchConfiguration<Object, Object, Map<String, Object>> searchConfiguration = registryDataConfiguration.getSearchConfiguration();
        JpaQueryBuilder<?> queryBuilder = this.classNameQueryBuilderMap.get(request.getClassFullName());
        ManagedTypeWrapper managedTypeWrapper = this.registryDataConfigurationHolder.resolveManagedTypeWrapper(request.getClassFullName());
        String idAttributeName = Optional.ofNullable(managedTypeWrapper.getIdAttributeName()).orElseGet(() -> managedTypeWrapper.getIdClassPropertyNameList().get(0));
        Pageable pageable = PageableUtil.convertToPageable((Integer)request.getPageNumber(), (Integer)request.getPageSize(), (SortProperty)new SortProperty(idAttributeName, SortDirection.ASC), (List)request.getSortPropertyList());
        Map searchRequestMap = Collections.emptyMap();
        if (request.getSearchParameter() != null) {
            searchRequestMap = this.stringToEntityPropertyMapConverter.convert(request.getSearchParameter().getQuery(), request.getSearchParameter().getPropertyNameList(), managedTypeWrapper.getIdentifiableType(), searchConfiguration.getSearchPropertyConfiguration());
        }
        CriteriaQuery query = queryBuilder.buildQuery(searchRequestMap, searchConfiguration, pageable.getSort());
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        typedQuery.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        return PageableExecutionUtils.getPage((List)typedQuery.getResultList(), (Pageable)pageable, () -> this.executeCountQuery(queryBuilder, query));
    }

    private long executeCountQuery(JpaQueryBuilder<?> queryBuilder, CriteriaQuery<?> query) {
        CriteriaQuery countQuery = queryBuilder.convertToCountQuery(query);
        List totals = this.entityManager.createQuery(countQuery).getResultList();
        return totals.stream().mapToLong(value -> value == null ? 0L : value).sum();
    }

    private <T> T resolveEntityInstance(Class<T> type, Object entityData) {
        if (entityData != null && type.equals(entityData.getClass())) {
            return (T)entityData;
        }
        return (T)BeanUtils.instantiateClass(type);
    }

    private void setIdFieldToOriginalValue(ManagedTypeWrapper managedTypeWrapper, Object instance, Object id) {
        Field field = ReflectionUtils.findField(instance.getClass(), (String)managedTypeWrapper.getIdAttributeName());
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        if (id.equals(field.get(instance))) {
            return;
        }
        field.set(instance, id);
    }
}

